<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- App favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('front/images/favicon-180x180.png')); ?>">
    
    <title><?php echo e($data['title']); ?> | <?php echo e(config('app.name', 'Personalised Gift Supply')); ?></title>

    <style>
        #loader {
            transition: all .3s ease-in-out;
            opacity: 1;
            visibility: visible;
            position: fixed;
            height: 100vh;
            width: 100%;
            background: #fff;
            z-index: 90000
        }
        .show-password{
            padding: 5px;
        }
        #loader.fadeOut {
            opacity: 0;
            visibility: hidden
        }
       
        .last-column-class{
            text-align: center;
        }
        .spinner {
            width: 40px;
            height: 40px;
            position: absolute;
            top: calc(50% - 20px);
            left: calc(50% - 20px);
            background-color: #333;
            border-radius: 100%;
            -webkit-animation: sk-scaleout 1s infinite ease-in-out;
            animation: sk-scaleout 1s infinite ease-in-out
        }
        
        @-webkit-keyframes sk-scaleout {
            0% {
                -webkit-transform: scale(0)
            }
            100% {
                -webkit-transform: scale(1);
                opacity: 0
            }
        }
        
        @keyframes  sk-scaleout {
            0% {
                -webkit-transform: scale(0);
                transform: scale(0)
            }
            100% {
                -webkit-transform: scale(1);
                transform: scale(1);
                opacity: 0
            }
        }

</style>

</head>

<link href = "https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css" rel = "stylesheet">
<script src = "https://code.jquery.com/jquery-1.10.2.js"></script>
<script src = "https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">

<!-- Datatables JS CDN -->
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

<body class="app">
    <div id="loader">
        <div class="spinner"></div>
    </div>
    <script>
    window.addEventListener("load", (function() {
        const t = document.getElementById("loader");
        setTimeout((function() {
            t.classList.add("fadeOut")
        }), 300)
    }))
    </script>
    <div>
        <?php echo $__env->make('admin.partials.left-side-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="page-container">

            <?php echo $__env->make('admin.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <main class="main-content bgc-grey-100">
                <div id="mainContent">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </main>

            <!-- ### $App Screen Footer ### -->
            <footer class="bdT ta-c p-30 lh-0 fsz-sm c-grey-600">
              <span><?php echo e(date('Y')); ?> © <?php echo e(env('APP_NAME')); ?>

            </footer>
        </div>
    </div>
    <?php echo $__env->make('admin.partials.table-list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/eux0emahe5gqllzf/public_html/app.personalisedgiftsupply.co.uk/web/resources/views/layouts/admin.blade.php ENDPATH**/ ?>