<?php $__env->startSection('content'); ?>
<style>
#storesTable tbody td {
    word-wrap: break-word!important;
    text-overflow: ellipsis;}
</style>    

 <div class="container-fluid">
    <h4 class="c-grey-900">Shpify Stores</h4>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-md-12">
            <div class="bgc-white bd bdrs-3 p-20 mB-20 table-responsive">
                <table class="table table-centered table-striped w-100 display" id="storesTable">
                    <thead>
                        <tr>
                            <th>Shop</th>
                            <th>Status</th>
                            <th>Created Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    
    $('#storesTable').DataTable({
        language: {
            paginate: {
                previous: "<i class='ti-angle-left'>",
                next: "<i class='ti-angle-right'>"
            }
        },
        drawCallback: function() {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded")
        },    
        processing: true,
        serverSide: true,
        pageLength: 20,
        lengthMenu: [20, 40, 60, 80, 100],
        ajax: "<?php echo e(url('admin/ajax-shopify-stores')); ?>",
        aaSorting : [[0, 'desc']],
        columnDefs: [{
            'targets': 'no-sort',
            'orderable': false,
        }],
        columns: [
            {
                data: 'shop'
            },
            {
                data: 'status'
            },
            {
                data: 'created_at'
            },
            {
                data: 'page_action'
            }
        ],        
    });
   
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eux0emahe5gqllzf/public_html/app.personalisedgiftsupply.co.uk/web/resources/views/admin/stores/lists.blade.php ENDPATH**/ ?>