<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('cors')->group(function () {
    Route::post('get-pgs-product-quantity', [App\Http\Controllers\CronController::class, 'getPgsProductQuantity'])->name('get-pgs-product-quantity');
});

Route::post('createorderbywebhook', [App\Http\Controllers\CronController::class, 'createOrderByWebhook'])->name('createorderbywebhook');

Route::post('updateproductinventory', [App\Http\Controllers\CronController::class, 'updateProductInventory'])->name('updateproductinventory');

Route::post('deleteproductbywebhook', [App\Http\Controllers\CronController::class, 'deleteProductByWebhook'])->name('deleteproductbywebhook');

Route::post('updateproductbywebhook', [App\Http\Controllers\CronController::class, 'updateProductByWebhook'])->name('updateproductbywebhook');

// collect product information using webhook
Route::post('get-pgs-product-api-webhook', [App\Http\Controllers\CronController::class, 'getPgsProductApiWebhook'])->name('get-pgs-product-api-webhook');

Route::delete('delete-pgs-product-api-webhook', [App\Http\Controllers\CronController::class, 'deletePgsProductApiWebhook'])->name('delete-pgs-product-api-webhook');

Route::get('/', function () {
    return "Hello API";
});
