<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// dd('dssaddsad');
Route::middleware(['auth:web'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {

    Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

    Route::get('settings', [App\Http\Controllers\Admin\DashboardController::class, 'settings'])->name('settings');

    Route::get('how-to-page', [App\Http\Controllers\Admin\DashboardController::class, 'viewHowToPage'])->name('how-to-page');

    Route::post('update-how-to-page', [App\Http\Controllers\Admin\DashboardController::class, 'updateHowToPage'])->name('update-how-to-page');

    Route::delete('delete-how-to-page-content/{id}', [App\Http\Controllers\Admin\DashboardController::class, 'deleteHowToPageContent'])->name('delete-how-to-page-content');

    Route::get('faq-page', [App\Http\Controllers\Admin\DashboardController::class, 'viewFaqPage'])->name('faq-page');

    Route::post('update-faq-page', [App\Http\Controllers\Admin\DashboardController::class, 'updateFaqPage'])->name('update-faq-page');

    Route::delete('delete-faq-page-content/{id}', [App\Http\Controllers\Admin\DashboardController::class, 'deleteFaqPageContent'])->name('delete-faq-page-content');

    Route::get('shopify-stores', [App\Http\Controllers\Admin\StoreController::class, 'index'])->name('shopify-stores');

    Route::get('ajax-shopify-stores', [App\Http\Controllers\Admin\StoreController::class, 'showShopifyStoreListing'])->name('ajax-shopify-stores');

    Route::get('shopify-store-orders/{store_id}', [App\Http\Controllers\Admin\StoreController::class, 'shopifyStoreOrders'])->name('shopify-store-orders');

    Route::get('ajax-shopify-store-orders', [App\Http\Controllers\Admin\StoreController::class, 'showshopifyStoreOrderListings'])->name('ajax-shopify-store-orders');

    Route::get('view-store-order/{store_id}/{order_id}', [App\Http\Controllers\Admin\StoreController::class, 'viewStoreOrder'])->name('view-store-order');

    Route::get('update-order-tacking-info/{store_id}/{order_item_id}', [App\Http\Controllers\Admin\StoreController::class, 'updateOrderTrackingInformation'])->name('update-order-tacking-info');

    Route::post('update-pgs-order-tracking', [App\Http\Controllers\Admin\StoreController::class, 'updatePgsOrderTrackings'])->name('update-pgs-order-tracking');

    // routing for change password & email
    Route::post('change-password', [App\Http\Controllers\Admin\SettingController::class, 'changePassword'])->name('change-password');

    Route::post('update-email', [App\Http\Controllers\Admin\SettingController::class, 'updateEmail'])->name('update-email');

});