@extends('layouts.login')

@section('content')

<div class="login_right d-flex flex-wrap align-items-center">
    <div class="lr_inner">
        <div class="login_title fpc text-center">
            <h3>{{ __('Forgot Password') }}</h3>
            <p class="mb-10">Please enter your email address to reset password.
                You will recieve a link to create new password via email.</p>
        </div>

        @if (session('status'))
        <div class="alert alert-success" role="alert">
            {{ session('status') }}
        </div>
        @endif
        <form method="POST" action="{{ route('password.email') }}" class="submitAuthForm">
            @csrf

            <div class="form_group">
                <label class="label">{{ __('Email Address') }}</label>
                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

                @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <div class="form_group">
                <button class="button2 saveFormButton">{{ __('Send') }}</button>
            </div>
        </form>

        <div class="registerhere text-center pt-2">
            <a href="{{ route('login') }}"> {{ __('Back to Login Page') }}</a>
        </div>
    </div>
</div>
@endsection
