@extends('layouts.login')

@section('content')

<style>
.field-icon {
  float: right;
  right: 15px;
  top: -37px;
  position: relative;
  z-index: 2;
}
</style>

<div class="login_right d-flex flex-wrap align-items-center">
    <div class="lr_inner">
        <div class="login_title text-center">
            <h3 class="fw-300 c-grey-900 mB-40">{{ __('Login') }}</h3>
        </div>
        @if (session('errorMsg'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {!! session('errorMsg') !!}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif
        @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {!! session('error') !!}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif
        @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {!! session('success') !!}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <form method="POST" action="{{ route('login') }}" class="submitAuthForm">
            @csrf

            <div class="form_group">
                <label class="label">{{ __('Email Address') }}</label>

                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>

                @error('email')
                <span class="invalid-feedback" role="alert">
                    {{ $message }}
                </span>
                @enderror
            </div>

            <div class="form_group">
                <label class="label">{{ __('Password') }}</label>

                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">
                
                <span toggle="#password" class="fa fa-fw fa-eye field-icon toggle-password"></span>                

                @error('password')
                <span class="invalid-feedback" role="alert">
                    {{ $message }}
                </span>
                @enderror
            </div>

            <div class="form_group d-flex flex-wrap align-items-center justify-content-between">

                <label class="rememberme">
                    <input class="mr-2 leading-tight" name="remember" type="checkbox" id="remember"> Remember Me
                </label>

                <div class="forgotpassword"><a href="{{ url('password/reset') }}">Forgot Password?</a></div>

            </div>

            <div class="form_group">
                <button class="button2 saveFormButton">Login</button>
            </div>

        </form>

    </div>
</div>

<script src="https://code.jquery.com/jquery-2.2.4.js" integrity="sha256-iT6Q9iMJYuQiMWNd9lDyBUStIq/8PuOW33aOqmvFpqI=" crossorigin="anonymous"></script>
<script>
$(".toggle-password").click(function() {

  $(this).toggleClass("fa-eye fa-eye-slash");
  var input = $($(this).attr("toggle"));
  if (input.attr("type") == "password") {
    input.attr("type", "text");
  } else {
    input.attr("type", "password");
  }
});
</script>
@endsection
