@extends('layouts.admin')
@section('content')

 <div class="container-fluid">
    <h4 class="c-grey-900">Shopify {{ $data['shop_name'] }} Stores Orders</h4>
    <br>
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-12">
        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-md-3"><strong>Order Number:</strong></div>
                    <div class="col-md-9 bg-red">{{ $data['order_info']->name }}</div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-3"><strong>Created Date:</strong></div>
                    <div class="col-md-9">{{ date('Y-m-d h:i:s a', strtotime($data['order_info']->created_at)) }}</div>
                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-md-12 text-center bg-red"><h4>Order Items Information</h4></div>
                </div>
                <hr>
                <br>
                @if(isset($data['order_info']->shopifyStoreOrderItem) && !empty($data['order_info']->shopifyStoreOrderItem))
                    @foreach($data['order_info']->shopifyStoreOrderItem as $orderitem)
                        @if($orderitem->is_pgs_store_order_id != '' && $orderitem->shopify_fulfillemnt_id == '' && $orderitem->shopify_fulfillemnt_status == '')
                            <div class="row">
                                <p class="text-center"><a href="{{ url('admin/update-order-tacking-info/'.$data['store_id'].'/'.$orderitem->id) }}" target="_blank">Add Tracking Info</a></p>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-3"><strong>Item Name:</strong></div>
                            <div class="col-md-9">{{ $orderitem->title }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Quantity:</strong></div>
                            <div class="col-md-9">{{ $orderitem->quantity }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Item SKU:</strong></div>
                            <div class="col-md-9">{{ $orderitem->sku }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Item Properties:</strong></div>
                            <div class="col-md-9">
                                @if(!empty($orderitem->properties))
                                    @php $propertiesData = json_decode($orderitem->properties); @endphp
                                    @foreach($propertiesData as $pKey => $property)
                                        
                                        @if($property->name == "_ Clip Art Image URL")
                                            <p> Clip Art Image - <a href="{{ $property->value }}" target="_blank">Link</a> </p>
                                        @else
                                            @if($property->name == 'CLIPART')
                                                <p> {{ $property->name }} - {{ CustomHelper::GetClipartReferNumber($property->value, $data['order_info']->personalised_gift_app_user_id, 'admin') }} </p>
                                            @else
                                            <p> {{ $property->name }} - {{ $property->value }} </p>
                                            @endif
                                        @endif
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Shipping Type Option:</strong></div>
                            <div class="col-md-9">{{ ($orderitem->is_order_shipping_value == 1) ? "Next Day Shipping" : '--------' }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Order ID:</strong></div>
                            <div class="col-md-9">{{ !empty($orderitem->is_pgs_store_order_id) ? $orderitem->is_pgs_store_order_id : '--------' }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS APP Order Status:</strong></div>
                            <div class="col-md-9">{{ !empty($orderitem->pgs_order_status) ? ucfirst($orderitem->pgs_order_status) : '--------' }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Tracking Id:</strong></div>
                            <div class="col-md-9">{{ !empty($orderitem->pgs_order_tracking_id) ? $orderitem->pgs_order_tracking_id : '--------' }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Processing Time:</strong></div>
                            <div class="col-md-9">{{ !empty($orderitem->pgs_order_processed_time) ? $orderitem->pgs_order_processed_time : '--------' }}</div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Shipping Services:</strong></div>
                            <div class="col-md-9">{{ !empty($orderitem->pgs_order_shipping_service) ? $orderitem->pgs_order_shipping_service : '--------' }}</div>
                        </div>
                        <hr>
                    @endforeach
                @endif
                <br>
                <div class="btn-row text-center">
                    <a href="{{ url('admin/shopify-store-orders/'.$data['store_id']) }}" class="btn btn-primary btn-flat cstm-btn">Back</a>												
                </div>
            </div>
        </div>
        </div>
    </div>
</div>

@endsection
