@extends('layouts.admin')
@section('content')
<style>
#storesTable tbody td {
    word-wrap: break-word!important;
    text-overflow: ellipsis;}
</style>    

 <div class="container-fluid">
    <h4 class="c-grey-900">Shpify Stores</h4>
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    <div class="row">
        <div class="col-md-12">
            <div class="bgc-white bd bdrs-3 p-20 mB-20 table-responsive">
                <table class="table table-centered table-striped w-100 display" id="storesTable">
                    <thead>
                        <tr>
                            <th>Shop</th>
                            <th>Status</th>
                            <th>Created Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    
    $('#storesTable').DataTable({
        language: {
            paginate: {
                previous: "<i class='ti-angle-left'>",
                next: "<i class='ti-angle-right'>"
            }
        },
        drawCallback: function() {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded")
        },    
        processing: true,
        serverSide: true,
        pageLength: 20,
        lengthMenu: [20, 40, 60, 80, 100],
        ajax: "{{ url('admin/ajax-shopify-stores') }}",
        aaSorting : [[0, 'desc']],
        columnDefs: [{
            'targets': 'no-sort',
            'orderable': false,
        }],
        columns: [
            {
                data: 'shop'
            },
            {
                data: 'status'
            },
            {
                data: 'created_at'
            },
            {
                data: 'page_action'
            }
        ],        
    });
   
</script>

@endsection
