@extends('layouts.admin')
@section('content')

<div class="container-fluid">
    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">
            
            <!-- start page title -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">{{ env('APP_NAME') }}</a></li>
                                <li class="breadcrumb-item active">Update Faq page content</li>
                            </ol>
                        </div>
                        <h4 class="page-title"></h4>
                    </div>
                </div>
            </div>     
            <!-- end page title --> 
                
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="masonry-item col-md-12">
                <div class="bgc-white p-20 bd">

                    <div class="mT-10">
                        <form class="form-horizontal submitFaqPageForm" method="POST" action="{{ route('admin.update-faq-page') }}" enctype="multipart/form-data">
                            @csrf

                            <div class="mb-3 col-md-12">
                                <label class="form-label" for="inputEmail4">Page Title</label>
                                <input type="text" class="form-control" name="faq_page_title" value="{{ $data['faq_page_title'] }}" maxlength="250" placeholder="Page Title" required>
                            </div>

                            @if($data['faq_contents']->count() > 0)
	                            <h5>Faq Lists</h5>
	                            <div class="row">
	                                @foreach($data['faq_contents'] as $content)
	                                <div class="col-lg-12">
	                                    <div class="mb-3 col-md-12">
											<label class="form-label" for="inputEmail4">Title<span class="text-danger">*</span></label>
											<input type="text" class="form-control" name="updated_title[]" value="{{ $content->title }}" maxlength="250" placeholder="Title" required>
									    </div>
									    <div class="mb-3 col-md-12">
											<label class="form-label" for="inputEmail4">Description<span class="text-danger">*</span></label>
											<textarea class="form-control" name="updated_description[]" class="form-control border-view" rows="5" required="required">{{ $content->description }}</textarea>
									    </div>
									    <input type="hidden" name="updated_faq_content_id[]" value="{{ $content->id }}">
	                                    <div class="mb-3 col-md-12 text-center deleteButton">
	                                        <button type="button" class="userDeleted btn btn-danger" data-toggle="modal" data-page-message="Do you really want to delete this faq data?"  data-page-link="{{ url('admin/delete-faq-page-content/'.$content->id) }}" data-page-link="" data-banner-image="">Delete</button>
	                                    </div>
	                                </div>
	                                @endforeach
	                            </div>
	                            <hr>
                            @endif

                            <div class="form-group align-items-center faq-increment mb-2">
                                <div class="col-lg-12 mb-2">
                                    <button class="btn btn btn-primary" type="button" id="addFaqPageSteps"><i class="ti-plus"></i> Add More Faq Lists</button>
                                </div>

                                <div class="row">
	                                <div class="col-lg-12">
	                                    <div class="mb-3 col-md-12">
											<label class="form-label" for="inputEmail4">Title<span class="text-danger">*</span></label>
											<input type="text" class="form-control" name="titles[]" maxlength="250" placeholder="Title" required>
									    </div>
									    <div class="mb-3 col-md-12">
											<label class="form-label" for="inputEmail4">Description<span class="text-danger">*</span></label>
											<textarea class="form-control" name="description[]" class="form-control border-view" rows="5" required="required"></textarea>
									    </div>
	                                </div>
	                            </div>                         
                            </div>

                            <input type="hidden" id="lastFaqStepsValue" value="0">

                            <div class="row">
                                <div class="col-md-12">
                                    <button type="submit" id="saveFaqPageButton" class="btn btn-primary btn-color">Update Faq Content</button>&nbsp;
                                    <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary btn-color">Back</a>
                                </div>
                           </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $("#saveFaqPageButton").on('click', function(e){
        e.preventDefault();
        $("#saveFaqPageButton").prop('disabled', true);
        $("#saveFaqPageButton").html('<span class="spinner-border spinner-border-sm mr-2" role="status" aria-hidden="true"></span> Submitting...');
        $("form.submitFaqPageForm").submit();
    });

    $(document).ready(function() {
        var faq_key = $('#lastFaqStepsValue').val();
        $("#addFaqPageSteps").click(function() {
            faq_key++;
            console.log(faq_key);
            var faq_html = "<div id='remove-faq-page-data-" + faq_key +
                "' class='clone hide form-group'><div class='form-group align-items-center'><div class='form-group mb-3 col-md-12'><label class='form-label' for='inputEmail4'>Title</label><input type='text' class='form-control' name='titles[]' maxlength='250'></div><div class='mb-3 col-md-12 form-group'><label class='form-label' for='inputEmail4'>Description</label><textarea name='description[]' rows='5' class='form-control border-view'></textarea></div><div class='input-group-btn'><div class='control-group input-group btn_title_remove' id=" +
                faq_key +
                " style='margin-top:10px;'><button class='btn btn-danger' type='button'><i class='ti-remove'></i> Remove</button></div></div></div></div><hr>";
            $(".faq-increment").after(faq_html);
            $('#lastFaqStepsValue').attr('value', faq_key);
        });

        $(document).on('click', '.btn_title_remove', function(e) {
            var button_id = $(this).attr("id");
            $('#remove-faq-page-data-' + button_id + '').remove();
        });
    });

</script>

@endsection