if(document.querySelector('.cnc_b2b_personalise_button')){

  var addSubmit = document.querySelector('[type="submit"]');
  var addName = document.querySelector('[name="add"]');
  
  if (addSubmit) {
    addSubmit.setAttribute('disabled', '');
  }
  
  if (addName) {
    addName.setAttribute('disabled', '');
  }
  
  var forms = document.querySelectorAll('Form[action="/cart/add"]');
  
  forms.forEach(function(form) {
    var submitButton = form.querySelector('[type="submit"]');
    if (submitButton) {
      submitButton.innerHTML += '<span class="tooltiptext">Please personalise your product before purchasing</span>';
    }
  });
  
  var globalfont = {
    'timesnewroman': 'Times New Roman',
    'zapfchancery': 'Zapf Chancery',
    'vivaldi': 'Vivaldi',
    'palacescript': 'Palace Script',
    'oldenglish': 'Old English',
    'lobsterregular': 'Lobster-Regular',
    'harrington': 'Harrington',
    'greatVibesregular': 'GreatVibes-Regular',
    'frenchscript': 'French Script',
    'edwardianscript': 'Edwardian Script',
    'curlz': 'Curlz',
    'chicleregular': 'Chicle Regular',
    'evilempire': 'Evil Empire',
    'mtcorsva': 'MTCORSVA',
    'eras': 'Eras',
    'copplerplate': 'Coppler Plate',
    'cooper': 'Cooper',
    'bauhaus': 'Bauhaus',
    'trumpit': 'Trumpit',
    'popwarner': 'Pop Warner'
  };
  
  // show the @font-face data in css
  var font_face = [],
  font_face = personalisedGiftAppFonts.data,
  newFontFace = document.querySelector('#personalised_css');
  
  for (var i = 0; i < font_face.length; i++) {
    var fontName = '.'+font_face[i].name_of_font.toLowerCase().replaceAll(' ', ''),
    capFontName = '.'+font_face[i].name_of_font.replaceAll(' ', ''),
    fontKey = font_face[i].name_of_font.replaceAll(' ', '');
    
    newFontFace.prepend(document.createTextNode("\
      @font-face {\
      font-family: '" + font_face[i].name_of_font + "';\
      src: url('" + font_face[i].font_file + "') format('woff');\
      font-weight: normal;\
      font-style: normal;\
      font-display: swap;\
    }\
    "));
    
    newFontFace.append(document.createTextNode("\
      " + fontName + "," + capFontName + " {\
      font-family: '" + font_face[i].name_of_font + "';\
    }\
    "));
    
    // add additional 120 fonts in globle font object 
    globalfont[fontKey] = fontKey;
  }  
  
  function myFunction() {
    document.getElementById("popup-modal").classList.add('show');
    document.getElementById("popup-modal").classList.remove('hide');
  }
  
  function closePopup() {
    document.getElementById("popup-modal").classList.remove('show');
    document.getElementById("popup-modal").classList.add('hide');
  }
  
  function fetchData() {
    // fetch fonts data from API

    var engrave_fonts = [];
    if(customiserData.engrave_fonts != undefined){
      engrave_fonts = Array.isArray(customiserData.engrave_fonts) ? customiserData.engrave_fonts : [customiserData.engrave_fonts];
    }
    
    if(engrave_fonts.length == 1){
      for (var i = 0; i < engrave_fonts.length; i++) {
        var option = document.createElement("option");
        option.value = engrave_fonts[i];
        option.text =  globalfont[engrave_fonts[i]];
        option.classList.add(engrave_fonts[i]);
        document.getElementById("font-choice").appendChild(option);
      }
      document.querySelector('#font-choice').closest('.line-item-property__field').parentElement.style.display = 'none';
    }else{
      
      if(customiserData.multiple_fonts != undefined && customiserData.multiple_fonts == 1 ){
        document.querySelector('#font-choice').closest('.line-item-property__field').parentElement.style.display = 'none';
      }
      if(engrave_fonts.length){
        for (var i = 0; i < engrave_fonts.length; i++) {
          if(globalfont[engrave_fonts[i]] != undefined){
            var option = document.createElement("option");
            option.value = engrave_fonts[i];
            option.text =  globalfont[engrave_fonts[i]]; 
            option.classList.add(engrave_fonts[i]);
            document.getElementById("font-choice").appendChild(option);
          }
        }
        
      }else{
        var globalfont_length = Object.keys(globalfont).length,
        glaobalfont_key = Object.keys(globalfont).sort(),
        glaobalfont_value = Object.values(globalfont).sort();
        
        for (var i = 0; i < globalfont_length; i++) {
          var option = document.createElement("option");
          option.value = glaobalfont_key[i];
          option.text =  glaobalfont_value[i];
          option.classList.add(glaobalfont_key[i]);
          document.getElementById("font-choice").appendChild(option);
        }
      }
    } 
    
      // create colour option 
    var available_color_label = [];
    if(customiserData?.available_color?.length > 0 ){
      if (customiserData?.available_color_label[0]?.length > 0) {
        for (var i = 0; i < customiserData.available_color_label.length; i++) {
          color = (customiserData.available_color[i][0] === '#') ? customiserData.available_color[i] : '#' + customiserData.available_color[i];
          var option = document.createElement("option");
          option.dataset.id = "1";
          if(customiserData.available_color_image != undefined){
            option.dataset.image = customiserData.available_color_image[i];
          }
          option.dataset.label = customiserData.available_color_label[i];
          option.value = customiserData.available_color_label[i];
          option.dataset.color = color;
          option.textContent = customiserData.available_color_label[i];
          document.getElementById("color_selection").appendChild(option);
        }
      }
      if (customiserData.color_for_variation === '1') {
        document.getElementById("color_selection").classList.add("color_for_variation");
      }
      if (customiserData.override_font_color === '1') {
        document.getElementById("color_selection").classList.add("override_font_color");
      }
    }else{
      document.getElementById("color_selection").parentElement.style.display = 'none';
    }
    
      // create input fields and that div elements
    for (var i = 1; i <= customiserData.engrave_no_of_customization; i++) {
      var sample_text = "sample_text_"+i,
      max_character = "max_character_"+i,
      font_color = "font_color_"+i,
      font_size = "font_size_"+i,
      position_top = "position_top_"+i,
      position_left = "position_left_"+i,
      engrave_height = "engrave_height_"+i,
      engrave_width = "engrave_width_"+i,
      engrave_fonts_override = "engrave_fonts_override_"+i;
      
      if(customiserData.font_color != undefined){
        var fontColorwithHash = (customiserData[font_color][0] === '#') ? customiserData[font_color] : '#' + customiserData[font_color];
      }
      
      if(customiserData?.multiple_fonts == 1){    
        var engrave_fonts = "engrave_fonts_"+i;
        var engrave_font = customiserData[engrave_fonts].toLowerCase();
      }else{
        var engrave_font = "";
      }
      
      if(customiserData[engrave_fonts_override] == 1){
        var engrave_fonts_override = 'override_this';
      }else{
        var engrave_fonts_override = '';
      }
      
      if(customiserData[sample_text]){
        var input_fields = document.getElementById('input_fields'),
        input_fields_div_parent = document.querySelector('#screenshort-wrapper');
        
        input_fields.innerHTML += '<div class="heading-input"><div class="line-property"><p class="line-item-property__field"><label for="line-'+i+'" style="width:50%"><strong>Line '+i+'</strong></label></p></div><div class="line-property"><p style="width: 100%; padding:0px; margin:0px; display:flex; justify-content:end; color:red;"><strong id="text-limit-'+i+'">'+customiserData[max_character]+'</strong></p></div></div><input id="line-'+i+'" type="text" name="properties[LINE '+i+']" maxlength="'+customiserData[max_character]+'">';
        input_fields_div_parent.innerHTML += '<div class="font_frontend '+engrave_font+' '+engrave_fonts_override+'" data-font_size="'+customiserData[font_size]+'" style="color:'+fontColorwithHash+'; font-size:'+customiserData[font_size]+'px; top:'+customiserData[position_top]+'px; left:'+customiserData[position_left]+'px; height:'+customiserData[engrave_height]+'px;  width:'+customiserData[engrave_width]+'px;" data-id="'+i+'"><div class="cnc_font_actual"></div></div><input type="hidden" name="cnc_font_size_'+i+'" value="'+customiserData[max_character]+'" id="cnc_font_size_'+i+'"><input type="hidden" name="cnc_current_font_size_'+i+'" value="'+customiserData[max_character]+'" id="cnc_current_font_size_'+i+'">';
      }
    }
    
      // show Image
    var image_url = customiserData.engravepreviewimage,
    image_width = customiserData.engrave_image_width+'px',
    image_height = customiserData.engrave_image_height+'px';
    
    if (image_url.includes("es.")) {
      image_url = image_url.replace("es.", "");
    }
    
    document.querySelector(".engrave_main_image").src = image_url;
    document.querySelector(".engrave_main_image").style.width = image_width;
    document.querySelector(".engrave_main_image").style.height = image_height;
    
      // fetch clipart data from API 
    if(customiserData.engrave_enable_clip_art == 1) {
      var clipart = [];
      clipart = personalisedGiftAppCliparts.data;
      
      for (var i = 0; i < clipart.length; i++) {
        var option = document.createElement("option");
        option.value = clipart[i].internal_name;
        option.text = clipart[i].name;
        option.dataset.height = clipart[i].height;
        option.dataset.width = clipart[i].width;
        option.dataset.image = clipart[i].image_url;
        document.getElementById("clip-art").appendChild(option);
      }
    }else{
      document.querySelector('#clip-art').closest('.line-item-property__field').parentElement.style.display = 'none';
    }
    
      // functionality of fields (Show text on image)  
    var input_fields_all = document.querySelector("#input_fields").querySelectorAll('input');
    input_fields_all.forEach((input, i) => {
      let font_frontend = document.querySelector('.font_frontend[data-id="'+ (i+1)+'"]');
      input.addEventListener("keyup", function(event){
        getfont();
        var line_value_length = parseInt(this.value.length),
        line_max_character = parseInt(this.getAttribute('maxlength'));
        document.querySelector('#text-limit-'+ (i+1)).innerHTML = line_max_character - line_value_length;
        font_frontend.querySelector('.cnc_font_actual').innerHTML  = this.value;
        
        // resize the font
        let cnc_font_actual = font_frontend.querySelector('.cnc_font_actual');
        
        while(cnc_font_actual.offsetWidth > font_frontend.offsetWidth){
          font_frontend.style.fontSize = parseFloat(font_frontend.style.fontSize) - 0.5 +'px';
        }
        if(cnc_font_actual.offsetWidth < font_frontend.offsetWidth){
          if(event.keyCode == 8 && parseFloat(font_frontend.style.fontSize) < parseFloat(font_frontend.dataset.font_size) || event.keyCode == 46 && parseFloat(font_frontend.style.fontSize) < parseFloat(font_frontend.dataset.font_size)){
            while(cnc_font_actual.offsetWidth < font_frontend.offsetWidth){
              font_frontend.style.fontSize = parseFloat(font_frontend.style.fontSize) + 0.5 +'px';
              if(parseFloat(font_frontend.style.fontSize) == parseFloat(font_frontend.dataset.font_size)){
                break;
              }
            };
          }         
        }
        font_frontend.querySelector('.cnc_font_actual').style.display = 'inline';
      });
    });
  }
  // fetch data function 
  fetchData();
  
  // The Image font size will automatically update when the font size option is selected.
  function update_fontsize(){
    var input_fields_all = document.querySelector("#input_fields").querySelectorAll('input');
    input_fields_all.forEach((input, i) => {
      let font_frontend = document.querySelector('.font_frontend[data-id="'+ (i+1)+'"]');
      if(input.value){
               // resize the font
        let cnc_font_actual = font_frontend.querySelector('.cnc_font_actual');
        
        while(cnc_font_actual.offsetWidth > font_frontend.offsetWidth){
          font_frontend.style.fontSize = parseFloat(font_frontend.style.fontSize) - 0.5 +'px';
        }
        if(cnc_font_actual.offsetWidth < font_frontend.offsetWidth){
         if(event.keyCode == 8 && parseFloat(font_frontend.style.fontSize) < parseFloat(font_frontend.dataset.font_size) || event.keyCode == 46 && parseFloat(font_frontend.style.fontSize) < parseFloat(font_frontend.dataset.font_size)){
           while(cnc_font_actual.offsetWidth < font_frontend.offsetWidth){
            font_frontend.style.fontSize = parseFloat(font_frontend.style.fontSize) + 0.5 +'px';
            if(parseFloat(font_frontend.style.fontSize) == parseFloat(font_frontend.dataset.font_size)){
             break;
           }
         };
       }         
     }
     font_frontend.querySelector('.cnc_font_actual').style.display = 'inline';
   }
 });
  }
  
  // get color 
  function getfontcolor() {
   var selectElement = document.querySelector('#color_selection');

   if(selectElement.classList.contains("color_for_variation")){
    document.querySelector(".engrave_main_image").setAttribute(
      "src",
      selectElement.querySelector("option:checked").getAttribute("data-image")
      );
    
    if(selectElement.classList.contains("override_font_color")){
      document.querySelector(".font_frontend").style.color = selectElement.querySelector("option:checked").getAttribute("data-color");
    }
  }else{
        // If variable product
    if(document.querySelector(".bc-product-variant__label")){
      document.querySelector(".font_frontend").style.color = selectElement.querySelector("option:checked").getAttribute("data-color");
    }else{
      var get_color_code = selectElement.options[selectElement.selectedIndex].dataset.color;
      const elements = document.querySelectorAll('.font_frontend.override_this');            
      elements.forEach(element => {
        element.style.color = get_color_code;
      });
    }
  }
}  

  // get option clipArt 
function getOption() {
  document.querySelector('.cnc_font_actual').style.display = 'inline';
  var selectElement = document.querySelector('#clip-art'),
  clipart_value = selectElement.value,
  image_data,
  height,
  width;
  
  document.querySelector("#input_fields").querySelectorAll('input').forEach((input,index) => {
    if(index == 0 || index == 1){
      document.querySelector('#text-limit-'+ (index+1)).innerHTML  = input.getAttribute('maxlength');
      if(document.querySelector('#clip-art').value != ''){
        image_data = selectElement.options[selectElement.selectedIndex].dataset.image,
        height = selectElement.options[selectElement.selectedIndex].dataset.height,
        width = selectElement.options[selectElement.selectedIndex].dataset.width;
        input.setAttribute('disabled',true);
        input.value = '';
        document.querySelector("#screenshort-wrapper").querySelectorAll('.cnc_font_actual').forEach((input,index) => {
          if(index == 0 || index == 1){
            input.textContent = ' ';
          }
        });
        document.querySelector('#screenshort-wrapper .font_frontend').firstChild.innerHTML += '<img class="artwork" src="'+image_data+'" style="height:'+height+'px !important;width:'+width+'px !important;max-height:'+height+'px !important;">';
      }else{
        if(index == 0){
          document.querySelector("#screenshort-wrapper img.artwork").remove(); 
        }
        input.removeAttribute('disabled');
      }
    }
  });
}

  // get font 
var previous_class = 'zapfchancery';
function getfont() {
  var selectElement = document.querySelector('#font-choice').value;
  document.querySelector('#screenshort-wrapper').classList.remove(previous_class);
  document.querySelector('#screenshort-wrapper').classList.add(selectElement);
  previous_class = selectElement;
  
  update_fontsize();
}

  //  send data in Add to cart form 
document.querySelector(".confirm_print").addEventListener('click', function(){
  var input_font_data = document.querySelector('#font-choice'),
  input_color_selection = document.querySelector('#color_selection'),
  input_clipart = document.querySelector('#clip-art'),
  input_clipart_data = input_clipart.options[input_clipart.selectedIndex].innerHTML,
  input_clipart_img_data = input_clipart.options[input_clipart.selectedIndex].dataset.image;
  let inputVal = true;
  document.querySelector("#input_fields").querySelectorAll('input').forEach(input => {
    if(input.value !== null && input.value !== ''){
      inputVal = false; 
    }
  });
  this.nextElementSibling.innerHTML = '';
  if(input_clipart.value == '' && inputVal){
    this.nextElementSibling.innerHTML = 'Please fill Personalise data';
    return false;
  }
  
  forms.forEach(form => {
    if(form.querySelector('input[name="'+input_font_data.name+'"]') == null &&  form.querySelector('input[name="'+input_font_data.name+'"]') == ''){
      form.querySelector('input[name="'+input_font_data.name+'"]').remove();
    }

    var engrave_fonts = [];
    if(customiserData.engrave_fonts != undefined){
      engrave_fonts = Array.isArray(customiserData.engrave_fonts) ? customiserData.engrave_fonts : [customiserData.engrave_fonts];
    }
    
    let inp_fd = document.createElement('input');
    if((engrave_fonts != undefined && engrave_fonts.length == 1) || (customiserData.multiple_fonts != undefined && customiserData.multiple_fonts == 1)){
      inp_fd.name = '_'+input_font_data.name;
    }else{
      inp_fd.name = input_font_data.name;
    }
    inp_fd.value = input_font_data.value;
    inp_fd.type = 'hidden';
    form.append(inp_fd);
    
    if(form.querySelector('input[name="'+input_color_selection.name+'"]') == null &&  form.querySelector('input[name="'+input_color_selection.name+'"]') == ''){
      form.querySelector('input[name="'+input_color_selection.name+'"]').remove();
    }
    let inp_cd = document.createElement('input');
    if(customiserData?.available_color?.length > 0 ){
      inp_cd.name = input_color_selection.name;
    }else{
      inp_cd.name = '_'+input_color_selection.name;
    }
    inp_cd.value = input_color_selection.value;
    inp_cd.type = 'hidden';
    form.append(inp_cd);
    
    if(form.querySelector('input[name="'+input_clipart.name+'"]') == null &&  form.querySelector('input[name="'+input_clipart.name+'"]') == ''){
      form.querySelector('input[name="'+input_clipart.name+'"]').remove();
    }
    if(form.querySelector('input[name="properties[_ Clip Art Image URL]"]') == null &&  form.querySelector('input[name="properties[_ Clip Art Image URL]"]') == ''){
      form.querySelector('input[name="properties[_ Clip Art Image URL]"]').remove();
    }
    
    if(input_clipart.value != null && input_clipart.value != '' ){
      let clipart = document.createElement('input');
      clipart.name = input_clipart.name;
      clipart.value = input_clipart_data;
      clipart.type = 'hidden';
      form.append(clipart);
      
      let clipart_img = document.createElement('input');
      clipart_img.name = "properties[_ Clip Art Image URL]";
      clipart_img.value = input_clipart_img_data;
      clipart_img.type = 'hidden';
      form.append(clipart_img);
    }
    
    document.querySelector("#input_fields").querySelectorAll('input').forEach((input) => {
      if(form.querySelector('input[name="'+input.name+'"]') == null &&  form.querySelector('input[name="'+input.name+'"]') == ''){
        form.querySelector('input[name="'+input.name+'"]').remove();
      }
      
      let inp = document.createElement('input');
      inp.name = input.name;
      inp.value = input.value;
      inp.type = 'hidden';
      form.append(inp);
    });   
  });
  document.querySelector('.Personalise-btn a.Pro-btn').innerHTML = 'Customization Confirmed';
  document.getElementById("popup-modal").classList.remove('show');
  document.getElementById("popup-modal").classList.add('hide');
  
  if (addSubmit) {
    addSubmit.removeAttribute('disabled');
  }
  
  if(addName){
    addName.removeAttribute('disabled');
  }     
    // document.querySelector('[class="tooltiptext"]').remove();
  document.querySelector('[class="tooltiptext"]').style.display = 'none';
}); 
  
  // reset form data after add to card product
  document.querySelectorAll('Form[action="/cart/add"]').forEach(form => {
    form.addEventListener('submit', function(){
      
      if (addSubmit) {
        addSubmit.setAttribute('disabled', '');
      }
      
      if (addName) {
        addName.setAttribute('disabled', '');
      }
      setTimeout(dataReset, 2000);
    }); 
  });
  
  function dataReset() {
    
    if(document.querySelector('.cnc_b2b_personalise_button')){
      document.querySelector('.Personalise-btn a.Pro-btn').innerHTML = '<svg enable-background="new 0 0 24 24" height="24px" id="Layer_1" version="1.1" viewBox="0 0 24 24" width="24px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M21.635,6.366c-0.467-0.772-1.043-1.528-1.748-2.229c-0.713-0.708-1.482-1.288-2.269-1.754L19,1C19,1,21,1,22,2S23,5,23,5  L21.635,6.366z M10,18H6v-4l0.48-0.48c0.813,0.385,1.621,0.926,2.348,1.652c0.728,0.729,1.268,1.535,1.652,2.348L10,18z M20.48,7.52  l-8.846,8.845c-0.467-0.771-1.043-1.529-1.748-2.229c-0.712-0.709-1.482-1.288-2.269-1.754L16.48,3.52  c0.813,0.383,1.621,0.924,2.348,1.651C19.557,5.899,20.097,6.707,20.48,7.52z M4,4v16h16v-7l3-3.038V21c0,1.105-0.896,2-2,2H3  c-1.104,0-2-0.895-2-2V3c0-1.104,0.896-2,2-2h11.01l-3.001,3H4z"></path></svg><span>Personalise</span>';
      document.getElementById("color_selection").innerHTML = '<option value="">Select Color</option>';
      document.getElementById("font-choice").innerHTML = '';
      document.getElementById("clip-art").innerHTML = '<option value="">(not selected)</option>';
      document.getElementById('input_fields').innerHTML = '';
      document.querySelector('#screenshort-wrapper').innerHTML = '<img class="engrave_main_image" src="https://www.allthingspersonalised.com/wp-content/uploads/2021/05/tallowhiskycustomiser.jpg" style=" width : 300px; height : 300px;">';
      fetchData();
      document.querySelector('[class="tooltiptext"]').style.display = 'block';
    }
  }
}

// send SKU of product for update inventory 
async function postJSON(url, data=null, method = 'GET') {
  try {
    if(method == 'GET'){
      const response = await fetch(url, {
        method: "GET",
        headers: {
          "Content-Type": "application/json",
        },
      });
      if(!response.ok){
        throw new Error('Parameter is not valid!');
      }
      
      return await response.json()
    }else{
      const response = await fetch(url, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify(data),
      });
      if(!response.ok){
        throw new Error('Parameter is not valid!');
      }
      
      return await response.json()
    }
  } catch (error) {
    console.log("Error:", error);
  }
}

var site_url = window.location.href;
var new_site_url = site_url.split('?')[0];
postJSON(new_site_url+'.js').then( data => {
  postJSON("https://app.personalisedgiftsupply.co.uk/api/get-pgs-product-quantity", {sku : data?.variants[0]?.sku, domain : Shopify.shop }, 'POST');
});