import React, { useState, useCallback, useEffect }from 'react';
import {
  Card,
  Page,
  EmptyState,
  Layout,
  TextContainer,
  SkeletonBodyText,
  Image,
  Stack,
  Link,
  Heading,
  Button,
  CalloutCard,
  Loading,
  Frame,
  Thumbnail,
} from "@shopify/polaris";
import { TitleBar } from "@shopify/app-bridge-react";

import { trophyImage } from "../assets";
import CheckThemeSupport from "./CheckThemeSupport";

import { ProductsCard } from "../components";
import { useAuthenticatedFetch } from "../hooks";
import { Toast } from "@shopify/app-bridge-react";

export default function HomePage() {

  const emptyToastProps = { content: null };
  const [isLoading, setIsLoading] = useState(false);
  const [pageLoader, setPageLoader] = useState(true);
  const [toastProps, setToastProps] = useState(emptyToastProps);
  const customFetch = useAuthenticatedFetch();
  const [themeStatus, setThemeStatus] = useState([]);
  const [themeStatusText, setThemeStatusText] = useState('');

  useEffect(() => {
      getActivateThemeStatus();
  }, []);

  const getActivateThemeStatus = async (type) => {

      setPageLoader(true);
      const response = await customFetch("/api/get-activate-theme-status").then(res => {
          return res.json();
      });
      
      if (response?.data) {
          setThemeStatus(response.data.length);
          setThemeStatusText(response.data);
          setPageLoader(false);

      } else {
          setPageLoader(false);
      }
  };

  const title = (
    <>
      <TextContainer>
        <p>
          It looks like your theme does not fully support the functionality of
          this app.
        </p>
        <p>
          Try switching to a different theme or contacting your theme developer
          to request support.
        </p>
      </TextContainer>
    </>
  );

  return (

    <Page fullWidth>
      <TitleBar title="Personalised Gift Supply" primaryAction={null} />
      <Layout>
        <Layout.Section>

        {themeStatus > 0 ?
           themeStatusText == 'active' ? 
            <>
            <Card sectioned>
              <Stack
                wrap={false}
                spacing="extraTight"
                distribution="trailing"
                alignment="center"
              >
                <Stack.Item fill>
                  <TextContainer spacing="loose">

                    <div class="banner-container">
                      <Image
                      source="https://app.personalisedgiftsupply.co.uk/pgs-app/shopify_public_homepage_banner.jpg"
                      alt="Banner Image"
                      style={{ width: "100%", overflowX: "hidden" }}
                    />
                    </div>
                    
                    {/* <Heading>Welcome to the Personalised Gift Supply 🎉</Heading>
                    
                    <p>
                      Your app is ready to explore! It contains everything you
                      need to get started including the{" "}
                      <Link url="https://polaris.shopify.com/" external>
                        Polaris design system
                      </Link>
                      ,{" "}
                      <Link url="https://shopify.dev/api/admin-graphql" external>
                        Shopify Admin API
                      </Link>
                      , and{" "}
                      <Link
                        url="https://shopify.dev/apps/tools/app-bridge"
                        external
                      >
                        App Bridge
                      </Link>{" "}
                      UI library and components.
                    </p>
                    <p>
                      Ready to go? Start populating your app with some sample
                      products to view and test in your store.{" "}
                    </p>
                    <p>
                      Learn more about building out your app in{" "}
                      <Link
                        url="https://shopify.dev/apps/getting-started/add-functionality"
                        external
                      >
                        this Shopify tutorial
                      </Link>{" "}
                      📚{" "}
                    </p> */}
                  </TextContainer>
                </Stack.Item>
               {/*  <Stack.Item>
                  <div style={{ padding: "0 20px" }}>
                    <Image
                      source={trophyImage}
                      alt="Nice work on building a Shopify app"
                      width={120}
                    />
                  </div>
                </Stack.Item> */}
              </Stack>
            </Card>
          </>
          : 
          <>
          <CheckThemeSupport />
          </>
        :
          <SkeletonBodyText />
          
        }
        </Layout.Section>
        <Layout.Section>
          {/* <ProductsCard /> */}
        </Layout.Section>
      </Layout>
    </Page>
  );
}
