import "./chunk-JUWXSDKJ.js";
import { Mocks } from "./api.js";
import { HeadersMock } from "./headers.js";
import { getStatusText } from "./statuses.js";
import { guessContentType } from "./utils.js";
const getError = (err) => {
  if (typeof err === "string") {
    return new TypeError(err);
  }
  return err;
};
class FetchMockInstance {
  constructor(options) {
    this.options = options;
    this.willResolveOnce = this.createWillResolve(true);
    this.willResolve = this.createWillResolve(false);
    this.willFailOnce = this.createWillFail(true);
    this.willFail = this.createWillFail(false);
    this.willThrowOnce = this.createWillThrow(true);
    this.willThrow = this.createWillThrow(false);
  }
  willResolveOnce;
  willResolve;
  willFailOnce;
  willFail;
  willThrowOnce;
  willThrow;
  getRoute() {
    return this.options.url;
  }
  getMethod() {
    return this.options.method;
  }
  get spy() {
    return this.options.spy;
  }
  get baseUrl() {
    return this.options.baseUrl;
  }
  getRouteCalls() {
    return this.options.spy.calls.filter((args) => this.isRoute(args));
  }
  getRouteResults() {
    const returns = [];
    this.spy.calls.forEach((call, index) => {
      if (this.isRoute(call)) {
        returns.push(this.spy.returns[index]);
      }
    });
    return returns;
  }
  withHeaders(headers) {
    this.options.headers = new HeadersMock(headers);
    return this;
  }
  willDo(fn) {
    Object.defineProperty(fn, "headers", {
      get: () => this.options.headers
    });
    Mocks.will(this.getMethod(), "do", this.getRoute(), this.options.includeQuery, false, fn);
    return this;
  }
  clear() {
    Mocks.clear(this.getMethod(), this.getRoute());
    return this;
  }
  setContentType(obj) {
    if (!this.options.headers.has("Content-Type")) {
      this.options.headers.set("Content-Type", guessContentType(obj || {}));
    }
  }
  createWillThrow(once) {
    return (error) => {
      Mocks.will(this.getMethod(), "throws", this.getRoute(), this.options.includeQuery, once, getError(error));
      return this;
    };
  }
  createWillResolve(once) {
    return (returns, statusCode = 200) => {
      this.setContentType(returns);
      Mocks.will(this.getMethod(), "resolves", this.getRoute(), this.options.includeQuery, once, {
        body: returns || {},
        statusCode,
        statusText: getStatusText(statusCode),
        headers: this.options.headers
      });
      return this;
    };
  }
  createWillFail(once) {
    return (body, statusCode = 500, statusText) => {
      this.setContentType(body);
      Mocks.will(this.getMethod(), "rejects", this.getRoute(), this.options.includeQuery, once, {
        body: body || {},
        statusCode,
        statusText: statusText || getStatusText(statusCode),
        headers: this.options.headers
      });
      return this;
    };
  }
  isRoute([input, options]) {
    const fetchPath = this.getRoute();
    const method = (options == null ? void 0 : options.method) || "GET";
    if (method !== this.options.method)
      return false;
    let url = typeof input === "string" ? input : input.url;
    if (!this.options.includeQuery) {
      [url] = url.split("?");
    }
    if (typeof fetchPath === "string" && url === fetchPath) {
      return true;
    }
    if (fetchPath instanceof RegExp) {
      return fetchPath.test(url);
    }
    return false;
  }
}
export {
  FetchMockInstance
};
