import { SpyImpl } from 'tinyspy';
import { HeadersMock } from './headers';
import { ResponseMock } from './response';

interface MockInstanceOptions {
    method: Method;
    url: string | RegExp;
    includeQuery: boolean;
    baseUrl: string;
    spy: SpyImpl<FetchArgs$1, Promise<Response>>;
    headers: HeadersMock;
}
declare type FetchArgs$1 = [input: RequestInfo, init?: RequestInit | undefined];
interface FetchSpyInstance {
    spy: SpyImpl<FetchArgs$1, Promise<Response>>;
    baseUrl: string;
    getRouteCalls(): FetchArgs$1[];
    getRouteResults(): ResponseMock[];
    getRoute(): string | RegExp;
    getMethod(): Method;
    /**
     * All requests will return this headers in Response object. If no headers are given,
     * will try to guess if from `returns` or `failes` values.
     * @default array [['Content-Type', 'application/json']]
     * @param headers Headers to set
     */
    withHeaders(headers: HeadersMockInit): FetchSpyInstance;
    /**
     * Fetch will return a response with the body
     * @param returns Body of the response. By-default: {}
     * @param statusCode Status code of the response. By-default: 200
     */
    willResolve<T>(returns?: T, statusCode?: number): FetchSpyInstance;
    willResolveOnce<T>(returns?: T, statusCode?: number): FetchSpyInstance;
    /**
     * Will return a response with failed status code and body
     * @param body Body of the request. By-default: {}
     * @param statusCode Status code. By-default: 500
     * @param statusText Status text. By-default: Internal error
     */
    willFail<T>(body?: T, statusCode?: number, statusText?: string): FetchSpyInstance;
    willFailOnce<T>(body?: T, statusCode?: number, statusText?: string): FetchSpyInstance;
    /**
     * Fetch will throw an error instead of returning a response
     * @param err Thrown error or a message of error to throw
     */
    willThrow(err: Error | string): FetchSpyInstance;
    willThrowOnce(err: Error | string): FetchSpyInstance;
    willDo(fn: (url: URL, ...args: FetchArgs$1) => Promise<MockValue> | MockValue): FetchSpyInstance;
    clear(): void;
}
declare class FetchMockInstance implements FetchSpyInstance {
    private options;
    willResolveOnce: FetchSpyInstance['willResolveOnce'];
    willResolve: FetchSpyInstance['willResolve'];
    willFailOnce: FetchSpyInstance['willFailOnce'];
    willFail: FetchSpyInstance['willFail'];
    willThrowOnce: FetchSpyInstance['willThrowOnce'];
    willThrow: FetchSpyInstance['willThrow'];
    constructor(options: MockInstanceOptions);
    getRoute(): string | RegExp;
    getMethod(): "GET" | "POST" | "PATCH" | "PUT" | "DELETE";
    get spy(): SpyImpl<FetchArgs$1, Promise<Response>>;
    get baseUrl(): string;
    getRouteCalls(): FetchArgs$1[];
    getRouteResults(): ResponseMock[];
    withHeaders(headers: HeadersMockInit): FetchSpyInstance;
    willDo(fn: AwaitedMockValue): this;
    clear(): this;
    private setContentType;
    private createWillThrow;
    private createWillResolve;
    private createWillFail;
    private isRoute;
}

declare const methods: readonly ["GET", "POST", "PATCH", "PUT", "DELETE"];
declare type Method = typeof methods[number];
declare type HeadersMockInit = Record<string, string | number | boolean> | Headers | string[][];
interface AwaitedMockValue {
    (url: URL, ...args: FetchArgs): Promise<MockValue> | MockValue;
    headers: HeadersMockInit;
}
interface MockValue {
    body?: unknown;
    statusCode?: number;
    statusText?: string;
    headers?: HeadersMockInit;
}
interface MockSuccessResult {
    type: 'rejects' | 'resolves' | 'do';
    value: MockValue | AwaitedMockValue;
}
declare type MockResult = MockSuccessResult | {
    type: 'throws';
    value: Error;
};
declare class MockStorage {
    private storage;
    will(method: Method, type: 'rejects' | 'resolves' | 'throws' | 'do', path: string | RegExp, includesQuery: boolean, once: boolean, value: MockValue | Error | AwaitedMockValue): void;
    getApiCall(fetchMethod: Method, urlPath: string): MockResult | undefined;
    clear(fetchMethod: Method, fetchUrl: string | RegExp): void;
    clearAll(): void;
}
declare const Mocks: MockStorage;
interface FetchGlobals {
    global: any;
    fetchKey: string;
}
declare function prepareFetch(obj?: any, key?: string): void;
declare type FetchArgs = [input: RequestInfo, init?: RequestInit | undefined];
interface FetchSpyFn {
    (method: Method, path: string | RegExp, includeQuery?: boolean): FetchSpyInstance;
}
interface FetchSpyFnShort {
    (path: string | RegExp, includeQuery?: boolean): FetchSpyInstance;
}
interface FetchSpy extends FetchSpyFn {
    clearAll(): void;
    options: MockOptions;
    setOptions(o: Partial<MockOptions>): void;
}
interface MockOptions extends FetchGlobals {
    baseUrl: string;
}
declare const mockFetch: FetchSpy;
declare const mockGet: FetchSpyFnShort;
declare const mockPost: FetchSpyFnShort;
declare const mockPatch: FetchSpyFnShort;
declare const mockDelete: FetchSpyFnShort;
declare const mockPut: FetchSpyFnShort;
declare function createMockFetch({ baseUrl, global, fetchKey, }?: Partial<MockOptions>): {
    mockFetch: FetchSpy;
    mockGet: FetchSpyFnShort;
    mockPost: FetchSpyFnShort;
    mockPatch: FetchSpyFnShort;
    mockDelete: FetchSpyFnShort;
    mockPut: FetchSpyFnShort;
};

export { AwaitedMockValue as A, FetchSpyInstance as F, HeadersMockInit as H, Method as M, mockDelete as a, mockGet as b, mockPatch as c, mockPost as d, mockPut as e, createMockFetch as f, FetchArgs$1 as g, FetchMockInstance as h, MockValue as i, Mocks as j, mockFetch as m, prepareFetch as p };
