import React from 'react';
import { LabelledProps } from '../Labelled';
import { FileUpload } from './components';
export declare type DropZoneFileType = 'file' | 'image' | 'video';
export interface DropZoneProps {
    /** Label for the file input */
    label?: React.ReactNode;
    /** Adds an action to the label */
    labelAction?: LabelledProps['action'];
    /** Visually hide the label */
    labelHidden?: boolean;
    /** ID for file input */
    id?: string;
    /** Allowed file types */
    accept?: string;
    /**
     * Whether is a file or an image
     * @default 'file'
     */
    type?: DropZoneFileType;
    /** Sets an active state */
    active?: boolean;
    /** Sets an error state */
    error?: boolean;
    /**
     * Displays an outline border
     * @default true
     */
    outline?: boolean;
    /**
     * Displays an overlay on hover
     * @default true
     */
    overlay?: boolean;
    /** Text that appears in the overlay */
    overlayText?: string;
    /** Text that appears in the overlay when set in error state */
    errorOverlayText?: string;
    /**
     * Allows multiple files to be uploaded at once
     * @default true
     */
    allowMultiple?: boolean;
    /** Sets a disabled state */
    disabled?: boolean;
    /** The child elements to render in the dropzone. */
    children?: string | React.ReactNode;
    /** Allows a file to be dropped anywhere on the page */
    dropOnPage?: boolean;
    /** Sets the default file dialog state */
    openFileDialog?: boolean;
    /** Allows child content to adjust height */
    variableHeight?: boolean;
    /** Adds custom validations */
    customValidator?(file: File): boolean;
    /** Callback triggered on click */
    onClick?(event: React.MouseEvent<HTMLElement>): void;
    /** Callback triggered on any file drop */
    onDrop?(files: File[], acceptedFiles: File[], rejectedFiles: File[]): void;
    /** Callback triggered when at least one of the files dropped was accepted */
    onDropAccepted?(acceptedFiles: File[]): void;
    /** Callback triggered when at least one of the files dropped was rejected */
    onDropRejected?(rejectedFiles: File[]): void;
    /** Callback triggered when one or more files are dragging over the drag area */
    onDragOver?(): void;
    /** Callback triggered when one or more files entered the drag area */
    onDragEnter?(): void;
    /** Callback triggered when one or more files left the drag area */
    onDragLeave?(): void;
    /** Callback triggered when the file dialog is canceled */
    onFileDialogClose?(): void;
}
export declare const DropZone: React.FunctionComponent<DropZoneProps> & {
    FileUpload: typeof FileUpload;
};
//# sourceMappingURL=DropZone.d.ts.map