import React from 'react';
interface Transition {
    /** Assign a transition duration to the collapsible animation. */
    duration?: string;
    /** Assign a transition timing function to the collapsible animation */
    timingFunction?: string;
}
export interface CollapsibleProps {
    /** Assign a unique ID to the collapsible. For accessibility, pass this ID as the value of the triggering component’s aria-controls prop. */
    id: string;
    /** Option to show collapsible content when printing */
    expandOnPrint?: boolean;
    /** Toggle whether the collapsible is expanded or not. */
    open: boolean;
    /** Override transition properties. When set to false, disables transition completely.
     * @default transition={{duration: 'var(--p-duration-150)', timingFunction: 'var(--p-ease-in-out)'}}
     */
    transition?: boolean | Transition;
    /** @deprecated Re-measuring is no longer necessary on children update **/
    preventMeasuringOnChildrenUpdate?: boolean;
    /** Callback when the animation completes. */
    onAnimationEnd?(): void;
    /** The content to display inside the collapsible. */
    children?: React.ReactNode;
}
export declare function Collapsible({ id, expandOnPrint, open, transition, preventMeasuringOnChildrenUpdate: _preventMeasuringOnChildrenUpdate, children, onAnimationEnd, }: CollapsibleProps): JSX.Element;
export {};
//# sourceMappingURL=Collapsible.d.ts.map
