import React from 'react';
import { classNames } from '../../../../utilities/css.js';
import { layer } from '../../../shared.js';
import styles from './TooltipOverlay.scss.js';
import { useI18n } from '../../../../utilities/i18n/hooks.js';
import { PositionedOverlay } from '../../../PositionedOverlay/PositionedOverlay.js';

function TooltipOverlay({
  active,
  activator,
  preferredPosition = 'below',
  preventInteraction,
  id,
  children,
  accessibilityLabel,
  width,
  padding,
  borderRadius,
  zIndexOverride,
  instant
}) {
  const i18n = useI18n();
  const markup = active ? /*#__PURE__*/React.createElement(PositionedOverlay, {
    active: active,
    activator: activator,
    preferredPosition: preferredPosition,
    preventInteraction: preventInteraction,
    render: renderTooltip,
    zIndexOverride: zIndexOverride
  }) : null;
  return markup;

  function renderTooltip(overlayDetails) {
    const {
      measuring,
      desiredHeight,
      positioning,
      chevronOffset
    } = overlayDetails;
    const containerClassName = classNames(styles.TooltipOverlay, measuring && styles.measuring, !measuring && styles.measured, instant && styles.instant, positioning === 'above' && styles.positionedAbove);
    const contentClassName = classNames(styles.Content, width && styles[width]);
    const contentStyles = measuring ? undefined : {
      minHeight: desiredHeight
    };
    const style = {
      '--pc-tooltip-chevron-x-pos': `${chevronOffset}px`,
      '--pc-tooltip-border-radius': borderRadius ? `var(--p-border-radius-${borderRadius})` : undefined,
      '--pc-tooltip-padding': padding && padding === 'default' ? 'var(--p-space-1) var(--p-space-2)' : `var(--p-space-${padding})`
    };
    return /*#__PURE__*/React.createElement("div", Object.assign({
      style: style,
      className: containerClassName
    }, layer.props), /*#__PURE__*/React.createElement("div", {
      id: id,
      role: "tooltip",
      className: contentClassName,
      style: { ...contentStyles,
        ...style
      },
      "aria-label": accessibilityLabel ? i18n.translate('Polaris.TooltipOverlay.accessibilityLabel', {
        label: accessibilityLabel
      }) : undefined
    }, children));
  }
}

export { TooltipOverlay };
