import React, { memo } from 'react';
import { classNames, variationName } from '../../utilities/css.js';
import { elementChildren, wrapWithComponent } from '../../utilities/components.js';
import styles from './Stack.scss.js';
import { Item } from './components/Item/Item.js';

/** @deprecated Use LegacyStack or AlphaStack instead. */
const Stack = /*#__PURE__*/memo(function Stack({
  children,
  vertical,
  spacing,
  distribution,
  alignment,
  wrap
}) {
  if (process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: <Stack /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyStack /> or <AlphaStack /> instead.');
  }

  const className = classNames(styles.Stack, vertical && styles.vertical, spacing && styles[variationName('spacing', spacing)], distribution && styles[variationName('distribution', distribution)], alignment && styles[variationName('alignment', alignment)], wrap === false && styles.noWrap);
  const itemMarkup = elementChildren(children).map((child, index) => {
    const props = {
      key: index
    }; // eslint-disable-next-line import/no-deprecated

    return wrapWithComponent(child, Item, props);
  });
  return /*#__PURE__*/React.createElement("div", {
    className: className
  }, itemMarkup);
}); // eslint-disable-next-line import/no-deprecated

Stack.Item = Item;

export { Stack };
