import React, { useMemo } from 'react';
import { buttonFrom } from '../Button/utils.js';
import { LegacyCard } from '../LegacyCard/LegacyCard.js';
import { SettingAction } from '../SettingAction/SettingAction.js';
import { globalIdGeneratorFactory } from '../../utilities/unique-id/unique-id-factory.js';

const getUniqueSettingToggleId = globalIdGeneratorFactory('SettingToggle');
function SettingToggle({
  enabled,
  action,
  children
}) {
  const id = useMemo(getUniqueSettingToggleId, []);
  const actionMarkup = action ? buttonFrom(action, {
    primary: !enabled,
    role: 'switch',
    id,
    ariaChecked: enabled ? 'true' : 'false'
  }) : null;
  return /*#__PURE__*/React.createElement(LegacyCard, {
    sectioned: true
  }, /*#__PURE__*/React.createElement(SettingAction, {
    action: actionMarkup
  }, /*#__PURE__*/React.createElement("label", {
    htmlFor: id
  }, children)));
}

export { SettingToggle };
