import React, { useEffect } from 'react';
import styles from './Grid.scss.js';
import { Cell } from './components/Cell/Cell.js';

/** @deprecated Use `Columns` instead or a combination of layout primitives (`Columns`, `Inline`, and `AlphaStack`) */
const Grid = function Grid({
  gap,
  areas,
  children,
  columns
}) {
  const style = {
    '--pc-grid-gap-xs': gap === null || gap === void 0 ? void 0 : gap.xs,
    '--pc-grid-gap-sm': gap === null || gap === void 0 ? void 0 : gap.sm,
    '--pc-grid-gap-md': gap === null || gap === void 0 ? void 0 : gap.md,
    '--pc-grid-gap-lg': gap === null || gap === void 0 ? void 0 : gap.lg,
    '--pc-grid-gap-xl': gap === null || gap === void 0 ? void 0 : gap.xl,
    '--pc-grid-columns-xs': columns === null || columns === void 0 ? void 0 : columns.xs,
    '--pc-grid-columns-sm': columns === null || columns === void 0 ? void 0 : columns.sm,
    '--pc-grid-columns-md': columns === null || columns === void 0 ? void 0 : columns.md,
    '--pc-grid-columns-lg': columns === null || columns === void 0 ? void 0 : columns.lg,
    '--pc-grid-columns-xl': columns === null || columns === void 0 ? void 0 : columns.xl,
    '--pc-grid-areas-xs': formatAreas(areas === null || areas === void 0 ? void 0 : areas.xs),
    '--pc-grid-areas-sm': formatAreas(areas === null || areas === void 0 ? void 0 : areas.sm),
    '--pc-grid-areas-md': formatAreas(areas === null || areas === void 0 ? void 0 : areas.md),
    '--pc-grid-areas-lg': formatAreas(areas === null || areas === void 0 ? void 0 : areas.lg),
    '--pc-grid-areas-xl': formatAreas(areas === null || areas === void 0 ? void 0 : areas.xl)
  };
  useEffect(() => {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn('Deprecation: <Grid /> is deprecated. This component will be removed in a future major version of Polaris. Use <Columns /> instead or a combination of <Columns />, <Inline />, and <AlphaStack />');
    }
  }, []);
  return /*#__PURE__*/React.createElement("div", {
    className: styles.Grid,
    style: style
  }, children);
};
function formatAreas(areas) {
  if (!areas) return;
  return `'${areas === null || areas === void 0 ? void 0 : areas.join(`' '`)}'`;
} // eslint-disable-next-line import/no-deprecated

Grid.Cell = Cell;

export { Grid, formatAreas };
