import { createElement } from 'react';
import { classNames, getResponsiveProps, sanitizeCustomProperties } from '../../utilities/css.js';
import styles from './AlphaStack.scss.js';

const AlphaStack = ({
  as = 'div',
  children,
  align,
  inlineAlign,
  gap,
  id,
  reverseOrder = false,
  ...restProps
}) => {
  const className = classNames(styles.AlphaStack, (as === 'ul' || as === 'ol') && styles.listReset, as === 'fieldset' && styles.fieldsetReset);
  const style = {
    '--pc-stack-align': align ? `${align}` : '',
    '--pc-stack-inline-align': inlineAlign ? `${inlineAlign}` : '',
    '--pc-stack-order': reverseOrder ? 'column-reverse' : 'column',
    ...getResponsiveProps('stack', 'gap', 'space', gap)
  };
  return /*#__PURE__*/createElement(as, {
    className,
    style: sanitizeCustomProperties(style),
    ...restProps
  }, children);
};

export { AlphaStack };
