import React from 'react';
import { buttonFrom } from '../Button/utils.js';
import { AlphaCard } from '../AlphaCard/AlphaCard.js';
import { SettingAction } from '../SettingAction/SettingAction.js';
import { AlphaStack } from '../AlphaStack/AlphaStack.js';
import { Avatar } from '../Avatar/Avatar.js';
import { Inline } from '../Inline/Inline.js';
import { Text } from '../Text/Text.js';
import { Box } from '../Box/Box.js';

function AccountConnection({
  connected = false,
  action,
  avatarUrl,
  accountName = '',
  title,
  details,
  termsOfService
}) {
  const initials = accountName ? accountName.split(/\s+/).map(name => name[0]).join('') : undefined;
  const avatarMarkup = connected ? /*#__PURE__*/React.createElement(Avatar, {
    accessibilityLabel: "",
    name: accountName,
    initials: initials,
    source: avatarUrl
  }) : null;
  const titleMarkup = title ? title : accountName;
  const detailsMarkup = details ? /*#__PURE__*/React.createElement(Text, {
    as: "span",
    color: "subdued"
  }, details) : null;
  const termsOfServiceMarkup = termsOfService ? /*#__PURE__*/React.createElement(Box, {
    paddingBlockStart: "5"
  }, termsOfService) : null;
  const actionElement = action ? buttonFrom(action, {
    primary: !connected
  }) : null;
  return /*#__PURE__*/React.createElement(AlphaCard, null, /*#__PURE__*/React.createElement(SettingAction, {
    action: actionElement
  }, /*#__PURE__*/React.createElement(Inline, {
    gap: "4"
  }, avatarMarkup, /*#__PURE__*/React.createElement(AlphaStack, {
    gap: "2"
  }, titleMarkup, detailsMarkup))), termsOfServiceMarkup);
}

export { AccountConnection };
