'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var SkeletonPage$1 = require('./SkeletonPage.scss.js');
var hooks = require('../../utilities/i18n/hooks.js');
var Box = require('../Box/Box.js');
var AlphaStack = require('../AlphaStack/AlphaStack.js');
var Inline = require('../Inline/Inline.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function SkeletonPage({
  children,
  fullWidth,
  narrowWidth,
  primaryAction,
  title = '',
  backAction,
  breadcrumbs
}) {
  const i18n = hooks.useI18n();
  const titleContent = title ? /*#__PURE__*/React__default["default"].createElement("h1", {
    className: SkeletonPage$1["default"].Title
  }, title) : /*#__PURE__*/React__default["default"].createElement("div", {
    className: SkeletonPage$1["default"].SkeletonTitle
  }, /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    background: "surface-neutral",
    minWidth: "120px",
    minHeight: "28px",
    borderRadius: "1"
  }));
  const primaryActionMarkup = primaryAction ? /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    id: "SkeletonPage-PrimaryAction",
    borderRadius: "1",
    background: "surface-neutral",
    minHeight: "2.25rem",
    minWidth: "6.25rem"
  }) : null;
  const breadcrumbMarkup = breadcrumbs || backAction ? /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    borderRadius: "1",
    background: "surface-neutral",
    minHeight: "2.25rem",
    minWidth: "2.25rem",
    maxWidth: "2.25rem"
  }) : null;
  return /*#__PURE__*/React__default["default"].createElement(AlphaStack.AlphaStack, {
    gap: "4",
    inlineAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(Box.Box, Object.assign({
    width: "100%",
    padding: "0",
    paddingInlineStart: {
      sm: '6'
    },
    paddingInlineEnd: {
      sm: '6'
    },
    maxWidth: "var(--pc-skeleton-page-max-width)",
    "aria-label": i18n.translate('Polaris.SkeletonPage.loadingLabel'),
    role: "status"
  }, narrowWidth && {
    maxWidth: 'var(--pc-skeleton-page-max-width-narrow)'
  }, fullWidth && {
    maxWidth: 'none'
  }), /*#__PURE__*/React__default["default"].createElement(AlphaStack.AlphaStack, null, /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    paddingBlockStart: {
      xs: '4',
      md: '5'
    },
    paddingBlockEnd: {
      xs: '4',
      md: '5'
    },
    paddingInlineStart: {
      xs: '4',
      sm: '0'
    },
    paddingInlineEnd: {
      xs: '4',
      sm: '0'
    },
    width: "100%"
  }, /*#__PURE__*/React__default["default"].createElement(Inline.Inline, {
    gap: "4",
    align: "space-between",
    blockAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(Inline.Inline, {
    gap: "4"
  }, breadcrumbMarkup, /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    paddingBlockStart: "1",
    paddingBlockEnd: "1"
  }, titleContent)), primaryActionMarkup)), /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    paddingBlockEnd: "2",
    width: "100%"
  }, children))));
}

exports.SkeletonPage = SkeletonPage;
