'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../utilities/css.js');
var AlphaStack$1 = require('./AlphaStack.scss.js');

const AlphaStack = ({
  as = 'div',
  children,
  align,
  inlineAlign,
  gap,
  id,
  reverseOrder = false,
  ...restProps
}) => {
  const className = css.classNames(AlphaStack$1["default"].AlphaStack, (as === 'ul' || as === 'ol') && AlphaStack$1["default"].listReset, as === 'fieldset' && AlphaStack$1["default"].fieldsetReset);
  const style = {
    '--pc-stack-align': align ? `${align}` : '',
    '--pc-stack-inline-align': inlineAlign ? `${inlineAlign}` : '',
    '--pc-stack-order': reverseOrder ? 'column-reverse' : 'column',
    ...css.getResponsiveProps('stack', 'gap', 'space', gap)
  };
  return /*#__PURE__*/React.createElement(as, {
    className,
    style: css.sanitizeCustomProperties(style),
    ...restProps
  }, children);
};

exports.AlphaStack = AlphaStack;
