'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var utils = require('../Button/utils.js');
var AlphaCard = require('../AlphaCard/AlphaCard.js');
var SettingAction = require('../SettingAction/SettingAction.js');
var AlphaStack = require('../AlphaStack/AlphaStack.js');
var Avatar = require('../Avatar/Avatar.js');
var Inline = require('../Inline/Inline.js');
var Text = require('../Text/Text.js');
var Box = require('../Box/Box.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function AccountConnection({
  connected = false,
  action,
  avatarUrl,
  accountName = '',
  title,
  details,
  termsOfService
}) {
  const initials = accountName ? accountName.split(/\s+/).map(name => name[0]).join('') : undefined;
  const avatarMarkup = connected ? /*#__PURE__*/React__default["default"].createElement(Avatar.Avatar, {
    accessibilityLabel: "",
    name: accountName,
    initials: initials,
    source: avatarUrl
  }) : null;
  const titleMarkup = title ? title : accountName;
  const detailsMarkup = details ? /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    as: "span",
    color: "subdued"
  }, details) : null;
  const termsOfServiceMarkup = termsOfService ? /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    paddingBlockStart: "5"
  }, termsOfService) : null;
  const actionElement = action ? utils.buttonFrom(action, {
    primary: !connected
  }) : null;
  return /*#__PURE__*/React__default["default"].createElement(AlphaCard.AlphaCard, null, /*#__PURE__*/React__default["default"].createElement(SettingAction.SettingAction, {
    action: actionElement
  }, /*#__PURE__*/React__default["default"].createElement(Inline.Inline, {
    gap: "4"
  }, avatarMarkup, /*#__PURE__*/React__default["default"].createElement(AlphaStack.AlphaStack, {
    gap: "2"
  }, titleMarkup, detailsMarkup))), termsOfServiceMarkup);
}

exports.AccountConnection = AccountConnection;
