import type { ClientApplication } from '@shopify/app-bridge';
import * as Button from '@shopify/app-bridge/actions/Button';
import * as ButtonGroup from '@shopify/app-bridge/actions/ButtonGroup';
import { Target, ActionProps, ActionGroupProps } from '../types';
export declare function generateRedirect(appBridge: ClientApplication, url?: string, target?: Target, external?: boolean): (() => void) | undefined;
export declare function transformActions(appBridge: ClientApplication, { primaryAction, secondaryActions, }: {
    primaryAction?: ActionProps;
    secondaryActions?: ActionProps[];
}): {
    primary?: Button.Button;
    secondary?: Button.Button[];
};
export declare function transformActions(appBridge: ClientApplication, { primaryAction, secondaryActions, actionGroups, }: {
    primaryAction?: ActionProps;
    secondaryActions?: ActionProps[];
    actionGroups?: ActionGroupProps[];
}): {
    primary?: Button.Button;
    secondary?: (Button.Button | ButtonGroup.ButtonGroup)[];
};
