import React from 'react';
import { AppBridgeContext } from '../../context';
import { LocationOrHref } from './route-propagator';
export interface Props {
    location: LocationOrHref;
}
/**
 * RoutePropagator component
 *
 * @remarks
 * React component which keeps the Shopify admin url in sync with the app url
 *
 * @public
 */
declare class RoutePropagator extends React.Component<Props, never> {
    static contextType: React.Context<import("../../context").IAppBridgeContext>;
    context: React.ContextType<typeof AppBridgeContext>;
    componentDidMount(): void;
    componentDidUpdate({ location: prevLocation }: Props): void;
    render(): null;
}
export default RoutePropagator;
