import { ActionVerb, ResourceType } from '@shopify/app-bridge/actions/ResourcePicker';
import type { BaseResource, Options, ResourceSelection, ProductOptions } from '@shopify/app-bridge/actions/ResourcePicker';
export interface SelectPayload {
    selection: ResourceSelection[];
}
interface BaseProps extends Options {
    open: boolean;
    /**
     * @deprecated as of 1.28.0
     */
    allowMultiple?: boolean;
    onSelection?(selectPayload: SelectPayload): void;
    onCancel?(): void;
}
export interface ProductPickerProps extends BaseProps, ProductOptions {
    resourceType: 'Product';
}
export interface ProductVariantProps extends BaseProps {
    resourceType: 'ProductVariant';
}
export interface CollectionPickerProps extends BaseProps {
    resourceType: 'Collection';
}
export declare type Props = ProductPickerProps | ProductVariantProps | CollectionPickerProps;
/**
 * ResourcePicker component
 *
 * @remarks
 * React component which wraps the Shopify App Bridge ResourcePicker action.
 *
 * @public
 */
declare function ResourcePicker({ open, resourceType, onSelection, onCancel, allowMultiple, selectMultiple, ...props }: Props): null;
export default ResourcePicker;
export type { BaseResource, Options, ProductOptions };
export { ActionVerb, ResourceType };
