/**
 * Add an item to a collection, return a function that can then be used to
 * remove the item from the collection. Optionally accepting a callback that is
 * invoked when the item is removed from the collection.
 *
 * @internal
 */
export declare function addAndRemoveFromCollection<T>(collection: T[], item: T, then?: Function): () => boolean;
/**
 * Remove the item from the collection. Optionally accepting a callback that is
 * invoked when the item is removed from the collection.
 *
 * @internal
 */
export declare function removeFromCollection<T>(collection: T[], item: T, then?: Function): boolean;
