import { ActionSet } from '../ActionSet';
import { ActionSetProps, Group, MetaAction } from '../types';
import { ClientApplication } from '../../client/types';
export declare enum Action {
    SHOW = "APP::TOAST::SHOW",
    CLEAR = "APP::TOAST::CLEAR",
    ACTION = "APP::TOAST::ACTION"
}
export interface Options {
    duration: number;
    isError?: boolean;
    message: string;
    onDismiss?: () => void;
    action?: {
        content: string;
    };
}
export interface ClearPayload {
    readonly id?: string;
}
export interface Payload extends Options {
    readonly id?: string;
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.Toast;
}
export interface ShowAction extends ActionBase {
    readonly type: typeof Action.SHOW;
    readonly payload: Payload;
}
export interface ClearAction extends ActionBase {
    readonly type: typeof Action.CLEAR;
}
export interface PrimaryAction extends ActionBase {
    readonly type: typeof Action.ACTION;
}
export declare type ToastAction = ShowAction | ClearAction | MetaAction;
export declare type ShowPayload = Omit<Payload, 'action'> & {
    action?: {
        content: string;
        onAction: () => void;
    };
};
export interface ToastApi {
    show: (payload: ShowPayload) => void;
    clear: (payload: ClearPayload) => void;
}
export declare function show(toastMessage: Payload): ShowAction;
export declare function clear(payload: ClearPayload): ClearAction;
export declare function primaryAction(payload: ClearPayload): PrimaryAction;
export declare class Toast extends ActionSet implements ActionSetProps<Options, Payload> {
    message: string;
    duration: number;
    isError?: boolean;
    action?: {
        content: string;
    };
    constructor(app: ClientApplication, options: Options);
    get options(): Options;
    get payload(): Payload;
    set(options: Partial<Options>): this;
    dispatch(action: Action): this;
}
