import { ClientApplication } from '../../client/types';
import { ActionSet } from '../ActionSet';
import { ActionSetProps, Group, MetaAction } from '../types';
export declare enum Action {
    OPEN = "APP::PICKER::OPEN",
    SELECT = "APP::PICKER::SELECT",
    UPDATE = "APP::PICKER::UPDATE",
    CANCEL = "APP::PICKER::CANCEL",
    SEARCH = "APP::PICKER::SEARCH",
    LOAD_MORE = "APP::PICKER::LOAD_MORE"
}
export declare type BadgeProgress = 'incomplete' | 'partiallyComplete' | 'complete';
export declare type BadgeStatus = 'success' | 'info' | 'attention' | 'critical' | 'warning' | 'new';
export declare type MediaKind = 'Avatar' | 'Thumbnail';
export declare type VerticalAlignment = 'leading' | 'trailing' | 'center';
/**
 * To be used on validator as matchEnum(...). Make sure as new values are added to update
 * the items below
 *
 * Note: Intentionally not using an `enum type` directly as this would cause a dependency
 * of the same enum on the consumer API rather than just the string values.
 */
export declare const ALL_BADGE_PROGRESSES: BadgeProgress[];
export declare const ALL_BADGE_STATUSES: BadgeStatus[];
export declare const ALL_MEDIA_KINDS: MediaKind[];
export declare const ALL_RESOURCE_VERTICAL_ALIGNMENT: VerticalAlignment[];
export interface AvatarProps {
    kind: MediaKind;
    accessibilityLabel: string;
    name: string;
    initials?: string;
    source: string;
}
export interface ThumbnailProps {
    kind: MediaKind;
    source: string;
    alt: string;
}
export interface Badge {
    id: string;
    content: string;
    progress: BadgeProgress;
    status: BadgeStatus;
}
/**
 * @internal
 *
 * @unstable This API may be updated without warning in the future
 */
export interface Resource {
    /** Resource's accessibility label */
    accessibilityLabel?: string;
    /** Indicators to display info in list item */
    badges?: Badge[];
    /** Wether the checkbox on a selectable item is disabled */
    disabled?: boolean;
    /** in GraphQL id format, ie 'gid://shopify/Product/1' */
    id: string;
    /** Whether the item should appear as a loading resource item or not */
    loading?: boolean;
    /** Content for the media area at the left of the item */
    media?: AvatarProps | ThumbnailProps;
    /** Individual item name used by various text labels */
    name: string;
    /** Individual item caption used to display extra information on the item */
    caption?: string;
    /** Display checkboxes next to items */
    /** @default true */
    selectable?: boolean;
}
/**
 * @public
 *
 * @unstable This API may be updated without warning in the future
 */
export interface BaseResource extends Resource {
    options?: Resource[];
}
export interface CancelPayload {
    readonly id?: string;
}
/**
 * withIllustration is a polaris prop that toggles the illustration
 */
export interface EmptySearchLabel {
    title: string;
    withIllustration: boolean;
    description: string;
}
export interface SelectPayload {
    readonly id?: string;
    selectedItems: BaseResource[];
}
export interface SearchPayload {
    readonly id?: string;
    searchQuery: string;
}
export interface LoadMorePayload {
    readonly id?: string;
}
export interface Options {
    /** Whether the picker can load more items on the list */
    canLoadMore?: boolean;
    /** An object that describes the interface of the picker when there is no item to display. */
    emptySearchLabel?: EmptySearchLabel;
    /** The list of items to display. */
    items: BaseResource[];
    /** Indicates if the Picker should be in a loading state. */
    loading?: boolean;
    /** Indicates if the Picker is currently loading more items. */
    loadingMore?: boolean;
    /** Limits the total number of selections to a maximum of the passed value, or 0 for no limit. */
    maxSelectable?: number;
    /** Limits the total number of selections to a maximum of the passed value, or 0 for no limit. */
    primaryActionLabel?: string;
    /** Text content of the search box when first loaded */
    searchQuery?: string;
    /** Used as the placeholder in the search input. */
    searchQueryPlaceholder?: string;
    /** Label to be used on the secondary action button. */
    secondaryActionLabel?: string;
    /** The items which are selected. */
    selectedItems?: BaseResource[];
    /** Used as the title of the modal. */
    title?: string;
    /** Adjust vertical alignment of elements */
    /** @default 'center' */
    verticalAlignment?: VerticalAlignment;
    /** Allow submission when no items are selected */
    /** @default false */
    allowEmptySelection?: boolean;
    /** Name of the resource, such as customers or products. **/
    resourceName?: {
        singular: string;
        plural: string;
    };
}
export interface Payload extends Omit<Partial<Options>, 'items'> {
    readonly id?: string;
    items: Options['items'];
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.unstable_Picker;
}
export interface SelectAction extends ActionBase {
    readonly type: typeof Action.SELECT;
    readonly payload: SelectPayload;
}
export interface UpdateAction extends ActionBase {
    readonly type: typeof Action.UPDATE;
    readonly payload: Payload;
}
export interface CancelAction extends ActionBase {
    readonly type: typeof Action.CANCEL;
}
export interface OpenAction extends ActionBase {
    readonly type: typeof Action.OPEN;
    readonly payload: Payload;
}
export interface SearchAction extends ActionBase {
    readonly type: typeof Action.SEARCH;
    readonly payload: SearchPayload;
}
export interface LoadMoreAction extends ActionBase {
    readonly type: typeof Action.LOAD_MORE;
}
export declare type PickerAction = SelectAction | UpdateAction | CancelAction | OpenAction | SearchAction | LoadMoreAction | MetaAction;
export declare function select(payload: SelectPayload): SelectAction;
export declare function open(payload: Payload): OpenAction;
export declare function cancel(payload: CancelPayload): CancelAction;
export declare function update(payload: Payload): UpdateAction;
export declare function search(payload: SearchPayload): SearchAction;
export declare function loadMore(payload: LoadMorePayload): LoadMoreAction;
export interface SelectEventListener {
    (data: SelectPayload): void;
}
export interface SearchEventListener {
    (data: SearchPayload): void;
}
export interface EventListener {
    (): void;
}
export interface Handlers {
    cancel: EventListener;
    loadMore: EventListener;
    search: SearchEventListener;
    select: SelectEventListener;
}
export interface PickerApi {
    open: (options?: Partial<Options>) => void;
    cancel: () => void;
    setOptions: (options: Partial<Options>) => void;
    addEventListener: <E extends keyof Handlers>(event: E, listener: Handlers[typeof event]) => void;
    removeEventListener: <E extends keyof Handlers>(event: E, listener: Handlers[typeof event]) => void;
}
/**
 * @unstable This API may be updated without warning in the future
 */
export declare class unstable_Picker extends ActionSet implements ActionSetProps<Options, Payload> {
    items: Options['items'];
    maxSelectable?: Options['maxSelectable'];
    selectedItems: Options['selectedItems'];
    title?: Options['title'];
    loading?: Options['loading'];
    searchQuery?: Options['searchQuery'];
    searchQueryPlaceholder?: Options['searchQueryPlaceholder'];
    primaryActionLabel?: Options['primaryActionLabel'];
    secondaryActionLabel?: Options['secondaryActionLabel'];
    emptySearchLabel?: Options['emptySearchLabel'];
    canLoadMore?: Options['canLoadMore'];
    loadingMore?: Options['loadingMore'];
    verticalAlignment?: Options['verticalAlignment'];
    allowEmptySelection?: Options['allowEmptySelection'];
    resourceName?: Options['resourceName'];
    constructor(app: ClientApplication, options: Options);
    get payload(): {
        id: string;
        /** Whether the picker can load more items on the list */
        canLoadMore?: boolean | undefined;
        /** An object that describes the interface of the picker when there is no item to display. */
        emptySearchLabel?: EmptySearchLabel | undefined;
        /** The list of items to display. */
        items: BaseResource[];
        /** Indicates if the Picker should be in a loading state. */
        loading?: boolean | undefined;
        /** Indicates if the Picker is currently loading more items. */
        loadingMore?: boolean | undefined;
        /** Limits the total number of selections to a maximum of the passed value, or 0 for no limit. */
        maxSelectable?: number | undefined;
        /** Limits the total number of selections to a maximum of the passed value, or 0 for no limit. */
        primaryActionLabel?: string | undefined;
        /** Text content of the search box when first loaded */
        searchQuery?: string | undefined;
        /** Used as the placeholder in the search input. */
        searchQueryPlaceholder?: string | undefined;
        /** Label to be used on the secondary action button. */
        secondaryActionLabel?: string | undefined;
        /** The items which are selected. */
        selectedItems?: BaseResource[] | undefined;
        /** Used as the title of the modal. */
        title?: string | undefined;
        /** Adjust vertical alignment of elements */
        /** @default 'center' */
        verticalAlignment?: VerticalAlignment | undefined;
        /** Allow submission when no items are selected */
        /** @default false */
        allowEmptySelection?: boolean | undefined;
        /** Name of the resource, such as customers or products. **/
        resourceName?: {
            singular: string;
            plural: string;
        } | undefined;
    };
    get options(): Options;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action, payload?: Payload): this;
    protected update(): void;
    protected open(): void;
    protected cancel(): void;
    protected loadMore(): void;
}
