import { FormLayout, TextField, Form, ButtonGroup, Button, SkeletonBodyText, IndexTable, useIndexResourceState, Text, ProgressBar, Page, AlphaStack, LegacyCard, Link, Stack, Pagination, Columns, TextContainer, Select } from '@shopify/polaris';
import React from 'react';
import { useState, useCallback, useEffect } from 'react';
import { useAuthenticatedFetch } from "../hooks";
import { Toast } from "@shopify/app-bridge-react";
import ThemeVerifyStatus from "./ThemeVerifyStatus";

export function UserProductList() {

  const emptyToastProps = { content: null };
  const [isLoading, setIsLoading] = useState(false);
  const [pageLoader, setPageLoader] = useState(true);
  const [filterPageLoader, setFilterPageLoader] = useState(true);
  const [toastProps, setToastProps] = useState(emptyToastProps);
  const [pgsProductData, setPgsProductData] = useState([]);
  const [pgsProductPrevPageUrlData, setPgsProductPrevPageUrlData] = useState(null);
  const [pgsProductNextPageUrlData, setpgsProductNextPageUrlData] = useState(null);
  const [pgsProductHasPrev, setPgsProductHasPrev] = useState(false);
  const [pgsProductHasNext, setPgsProductHasNext] = useState(true);
  const [searchFieldValue, setSearchFieldValue] = useState('');
  const [automatedJobStatus, setAutomatedJobStatus] = useState('');
  const [isSyncDataLoading, setIsSyncDataLoading] = useState(false);
  const [pgsCountTotalProduct, setPgsCountTotalProduct] = useState(false);
  const [pgsCountSyncingProduct, setPgsCountSyncingProduct] = useState(false);
  const [pgsUserStatus, setPgsUserStatus] = useState('');
  const [pgsImportProductStatus, setPgsImportProductStatus] = useState('');
  const [shopifyThemeStatus, setShopifyThemeStatus] = useState('');
  const [progressStatus, setProgressStatus] = useState(0);
  const [showProgressMessage, setShowProgressMessage] = useState('');
  const [selectedCategory, setSelectedCategory] = useState('');
  const [categoryOptions, setCategoryOptions] = useState([]);
  
  const customFetch = useAuthenticatedFetch();

  useEffect(() => {
    getProductsData();
    getCategoriesData();
  }, []);
  
  useEffect(() => {
    getProductsData('/api/get-products-data?search=' + searchFieldValue+'&category='+ selectedCategory);
  }, [searchFieldValue,selectedCategory]);
  
  const getCategoriesData = async () => {

    const response = await customFetch("/api/get-categories-data").then(res => {
        return res.json();
    });

    if (response.status) {
        setCategoryOptions(response.data);
    }
  };
   
  const handleCategoryChange = useCallback(
    (value) => setSelectedCategory(value),
    [],
  );

  const getProductsData = async (url = null) => {

    setPageLoader(true);
    setProgressStatus(0);
    setShowProgressMessage('');

    if (url == null) {
      url = "/api/get-products-data";
    }

    const response = await customFetch(url).then(res => {
      return res.json();
    });
    
    if(selectedCategory || searchFieldValue){
        setFilterPageLoader(false);
    }else{
         setFilterPageLoader(true);
    }

    if (response.status) {
      setPgsProductData(response.data);
      setPgsProductHasPrev(response.prev_page_url == null ? false : true);
      setPgsProductHasNext(response.next_page_url == null ? false : true);
      setPgsProductPrevPageUrlData(response.prev_page_url);
      setpgsProductNextPageUrlData(response.next_page_url);
      setPageLoader(false);
      setFilterPageLoader(false);
      setPgsCountTotalProduct(response.total_pgs_products);
      setPgsUserStatus(response.pgs_app_active_status);
      setPgsImportProductStatus(response.pgs_app_import_product_status);
      setPgsCountSyncingProduct(response.syncing_total_pgs_products);
      setShopifyThemeStatus(response.theme_status);
      setAutomatedJobStatus(response.automated_job_status);
    } else {
      setPageLoader(false);
      setFilterPageLoader(false);
    }

  };

  const syncPgsProduct = async () => {

    setIsSyncDataLoading(true);

    const response = await customFetch("/api/get-pgs-products").then(res => {
      return res.json();
    });

    if (response.status) {    
      setToastProps({ content: response.message });
      setIsSyncDataLoading(false);
      getCategoriesData();
      getProductsData('/api/get-products-data?search=' + searchFieldValue+'&category='+ selectedCategory);
    } else {
      setIsSyncDataLoading(false);
      setToastProps({
        content: response.message,
        error: true,
      });
    }

  };
  
  const createProductOnShopify = async ( productid = null, e = null) => {
    if (e) {      
      e.stopPropagation();
    }
    setPageLoader(true);
    setFilterPageLoader(false);
    setShowProgressMessage('Adding products, please wait');

    if (productid !== null) {
        selectedResources.push(productid);
    }

    const totalRecords = selectedResources.length;
    const counterPercentage = (1/totalRecords)*100;
    let counter = 0;
    for (let index = 0; index < totalRecords; index++) {
      
      const formData = new FormData();
      formData.append('product_ids', selectedResources[index]);

      try {
        const response = await customFetch('/api/create-products-on-shopify', {
          method: 'POST', // *GET, POST, PUT, DELETE, etc.       
          body: formData // body data type must match "Content-Type" header
        }).then(res => {
          return res.json();
        });
        
        if (response.status) {
          counter = counter + counterPercentage;
          // console.log({counter});
          setProgressStatus(Math.round(counter));

          if (index + 1 === totalRecords) {
            setToastProps({ content: response.message });
            setPageLoader(false);
            setFilterPageLoader(false);
            getProductsData('/api/get-products-data?search=' + searchFieldValue+'&category='+ selectedCategory);
          }

          handleSelectionChange('all', false);
        } else {
          setPageLoader(false);
          setFilterPageLoader(false);
          setToastProps({
            content: response.message,
            error: true
          });
        }
      } catch (error) {
        console.error(error);
        // Handle any error that occurred during the API call
      }
    }
    
  };
  
  const viewPgsProductLink = async ( site_link = null, e = null) => {
    if (e) {      
      e.stopPropagation();
    }
    window.open(site_link, '_blank');
    
  };

  /* const createProductOnShopify = async ( productid = null, e = null) => {
    if (e) {      
      e.stopPropagation();
    }
    setPageLoader(true);

    const formData = new FormData();
    if (productid !== null) {
      formData.append("product_ids", productid);
    } else {
      formData.append("product_ids", selectedResources.join(','));
    }

    const response = await customFetch("/api/create-products-on-shopify", {
      method: 'POST', // *GET, POST, PUT, DELETE, etc.       
      body: formData // body data type must match "Content-Type" header
    }).then(res => {
      return res.json();
    });

    if (response.status) {

      setToastProps({ content: response.message });
      setPageLoader(false);
      getProductsData();
      handleSelectionChange('all', false);
      
    } else {

      setPageLoader(false);
      setToastProps({
        content: response.message,
        error: true,
      });
    }
  }; */

  const handleSearchSubmit = () => {
    getProductsData('/api/get-products-data?search=' + searchFieldValue+'&category='+ selectedCategory);
  };

  const handleTextFieldChange = useCallback(
    (value) => setSearchFieldValue(value),
    [],
  );

  const handleClearButtonClick = useCallback(() => handleClearSearch(), []);
  
  const handleResetButtonClick = useCallback(() => handleAllClearSearch(), []);

  const handleClearSearch = () => {
    setSearchFieldValue('');
  }
  
  const handleAllClearSearch = () => {
    setSearchFieldValue('');
    setSelectedCategory('');
  }

  const toastMarkup = toastProps.content && (
    <Toast {...toastProps} onDismiss={() => setToastProps(emptyToastProps)} />
  );

  const resourceName = {
    singular: 'products',
    plural: 'products',
  };

  const { selectedResources, allResourcesSelected, handleSelectionChange } =
    useIndexResourceState(pgsProductData);

  const rowMarkup = pgsProductData.map(
    (
      { id, post_title, pgs_link, shopify_edit_product_link, shopify_preview_product_link },
      index,
    ) => (
      <IndexTable.Row
        id={id}
        key={id}
        selected={selectedResources.includes(id)}
        position={index}
      >
        <IndexTable.Cell>
          <Text variant="bodyMd" fontWeight="bold" as="span">
            {post_title}
          </Text>
        </IndexTable.Cell>
        <IndexTable.Cell>

            {shopify_edit_product_link ?
              <ButtonGroup spacing='tight'>
                <Button size="slim" destructive dataPrimaryLink loading={isLoading} onClick={(e) => viewPgsProductLink(shopify_edit_product_link, e)} external={false}>Edit Product</Button>
                <Button size="slim" destructive dataPrimaryLink loading={isLoading} onClick={(e) => viewPgsProductLink(shopify_preview_product_link, e)} external={false}>View Product</Button>
                <div style={{ backgroundColor: '#8f28a1', color: 'white' }}>
                  <Button size="slim" monochrome outline dataPrimaryLink loading={isLoading} onClick={(e) => viewPgsProductLink(pgs_link, e)} external={false}>View Product in PGS</Button>
                </div>
              </ButtonGroup>
              :
              <ButtonGroup spacing='tight'>
                <Button size="slim" primary loading={isLoading} dataPrimaryLink onClick={(e) => createProductOnShopify(id, e)} external={false}>Create Product on the Store</Button>
                <div style={{ backgroundColor: '#8f28a1', color: 'white' }}>
                  <Button size="slim" monochrome outline dataPrimaryLink loading={isLoading} onClick={(e) => viewPgsProductLink(pgs_link, e)} external={false}>View Product in PGS</Button>
                </div>
              </ButtonGroup>
            }

        </IndexTable.Cell>
      </IndexTable.Row>
    ),
  );

  const promotedBulkActions = [
    {
      content: 'Create Products on Shopify',
      onAction: () => createProductOnShopify(null),
    },
  ];

  // const bulkActions = [
  //   {
  //     content: 'Add tags',
  //     onAction: () => console.log('Todo: implement bulk add tags'),
  //   }
  // ];

  return (
    <>
      {toastMarkup}
      {filterPageLoader ? <SkeletonBodyText /> :
          shopifyThemeStatus ?
          <Columns gap="4" columns={1}>
            {(pgsUserStatus === 1) && (
              <Columns gap="4" columns={['twoThirds', 'oneThird']}><AlphaStack></AlphaStack>
                <AlphaStack>
                <Text as="p" fontWeight="regular">
                  Total Product sync {pgsCountSyncingProduct} out of {pgsCountTotalProduct}.
                </Text>
                { (automatedJobStatus === 0) ?
                    <>
                        <Button primary loading={isSyncDataLoading} onClick={() => syncPgsProduct()}>Check For New Products</Button>
                    </>
                    :
                    <>
                        <Button primary disabled>
                            Sync is currently running, please try again shortly.
                        </Button>
                    </>
                }
                </AlphaStack>
              </Columns>
            )}
            
             <TextField
              label="Products Filter"
              type="search"
              value={searchFieldValue}
              onChange={handleTextFieldChange}
              clearButton
              onClearButtonClick={handleClearButtonClick}
              autoComplete="off"
              connectedLeft={
                <Select
                  value={selectedCategory}
                  label="Category"
                  onChange={handleCategoryChange}
                  labelHidden
                  options={categoryOptions}
                />
              }
              connectedRight={
                    <ButtonGroup>
                      {/* <Button primary onClick={() => handleSearchSubmit()} fullWidth={true}>
                        Submit
                      </Button> */ }
                      {selectedCategory || searchFieldValue ?
                          <>
                          <Button label="" destructive onClick={() => handleResetButtonClick()} fullWidth={true}>
                            Reset
                          </Button>
                          </>
                        :
                        <></>
                        }
                    </ButtonGroup>
                }
            />

            {pageLoader ? <><ProgressBar progress={progressStatus} animated={false} /> <div style={{ marginTop: '1rem' }}><TextContainer><Text variant="headingLg" as="h5" color="critical">{showProgressMessage}</Text></TextContainer></div> </>:
                <>
                <IndexTable
                  resourceName={resourceName}
                  itemCount={pgsProductData.length}
                  selectedItemsCount={
                    allResourcesSelected ? 'All' : selectedResources.length
                  }
                  onSelectionChange={handleSelectionChange}
                  headings={[
                    { title: 'Title' },
                    { title: 'Action' },
                  ]}
                  // bulkActions={bulkActions}
                  promotedBulkActions={promotedBulkActions}
                >
                  {rowMarkup}
    
                </IndexTable>
                <AlphaStack inlineAlign="center"><Pagination
                  hasPrevious={pgsProductHasPrev}
                  onPrevious={() => getProductsData(pgsProductPrevPageUrlData)}
                  hasNext={pgsProductHasNext}
                  onNext={() => getProductsData(pgsProductNextPageUrlData)}
                />
                </AlphaStack>
                </>
            }
          </Columns>
        :
          <><ThemeVerifyStatus /></>
      }
    </>
  );


}