import { FormLayout, TextField, Form, Button, SkeletonBodyText, Text, Page, AlphaStack, Divider, Card, LegacyCard, LegacyStack, Collapsible, TextContainer, Link, Icon } from '@shopify/polaris';
import React from 'react';
import { useState, useCallback, useEffect } from 'react';
import { useAuthenticatedFetch } from "../hooks";
import { Toast } from "@shopify/app-bridge-react";
import { MobileCancelMajor, MobilePlusMajor } from '@shopify/polaris-icons';
import ThemeVerifyStatus from "./ThemeVerifyStatus";

export function UserFaqPage() {

    const emptyToastProps = { content: null };
    const [isLoading, setIsLoading] = useState(false);
    const [pageLoader, setPageLoader] = useState(true);
    const [toastProps, setToastProps] = useState(emptyToastProps);
    const [pageContentData, setPageContentData] = useState([]);
    const [pageTitle, setPageTitle] = useState([]);
    const [shopifyThemeStatus, setShopifyThemeStatus] = useState('');

    const customFetch = useAuthenticatedFetch();

    const [open, setOpen] = useState({});

    useEffect(() => {
        getFaqPageData();
    }, []);

    const getFaqPageData = async () => {

        setPageLoader(true);
        const response = await customFetch("/api/get-faq-page-contents").then(res => {
            return res.json();
        });

        if (response.status) {
            setPageContentData(response.data);
            setPageTitle(response.page_title);
            setShopifyThemeStatus(response.theme_status);
            setPageLoader(false);

        } else {
            setPageLoader(false);
        }
    };

    const handleToggle = (id) => {
        setOpen(prevState => ({
          ...prevState,
          [id]: !prevState[id],
        }));
    };    

    const toastMarkup = toastProps.content && (
        <Toast {...toastProps} onDismiss={() => setToastProps(emptyToastProps)} />
    );

    return (
        <>
            {toastMarkup}
            {pageLoader ? <SkeletonBodyText /> :
                shopifyThemeStatus ?
                    <Card sectioned title={pageTitle}>
                        <Page fullWidth>
                            {pageContentData.map((content) => (
                                <>
                                    <LegacyCard sectioned>
                                        <LegacyStack vertical>
                                            <Text as="p" fontWeight="regular">
                                                {content?.title}
                                            </Text>

                                            <Button onClick={() => handleToggle('example-collapsible-'+content?.id)}>

                                                {open['example-collapsible-'+content?.id] ? <Icon source={MobileCancelMajor} color="base" /> : <Icon source={MobilePlusMajor} color="base" />}
                                                
                                            </Button>

                                            <Collapsible
                                                open={open['example-collapsible-'+content?.id]}
                                                id={"example-collapsible-"+content?.id}
                                                transition={{ duration: '100ms', timingFunction: 'ease-in-out' }} expandOnPrint
                                            >
                                                <TextContainer>
                                                    <Text as="p" fontWeight="regular">
                                                        {content?.description}
                                                    </Text>
                                                </TextContainer>
                                            </Collapsible>
                                        </LegacyStack>
                                    </LegacyCard>
                                </>
                            ))}
                        </Page>
                    </Card>
                :   
                    <><ThemeVerifyStatus /></>
            }
        </>
    );

}