import { MetricRatingThresholds, ReportCallback, ReportOpts } from './types.js';
/** Thresholds for TTFB. See https://web.dev/ttfb/#what-is-a-good-ttfb-score */
export declare const TTFBThresholds: MetricRatingThresholds;
/**
 * Calculates the [TTFB](https://web.dev/time-to-first-byte/) value for the
 * current page and calls the `callback` function once the page has loaded,
 * along with the relevant `navigation` performance entry used to determine the
 * value. The reported value is a `DOMHighResTimeStamp`.
 *
 * Note, this function waits until after the page is loaded to call `callback`
 * in order to ensure all properties of the `navigation` entry are populated.
 * This is useful if you want to report on other metrics exposed by the
 * [Navigation Timing API](https://w3c.github.io/navigation-timing/). For
 * example, the TTFB metric starts from the page's [time
 * origin](https://www.w3.org/TR/hr-time-2/#sec-time-origin), which means it
 * includes time spent on DNS lookup, connection negotiation, network latency,
 * and server processing time.
 */
export declare const onTTFB: (onReport: ReportCallback, opts?: ReportOpts) => void;
