import "./chunk-JUWXSDKJ.js";
import { Appeandable } from "./appeanable.js";
function normalizeName(name) {
  if (typeof name !== "string") {
    name = String(name);
  }
  if (/[^a-z0-9\-#$%&'*+.^_`|~!]/i.test(name) || name === "") {
    throw new TypeError('Invalid character in header field name: "' + name + '"');
  }
  return name.toLowerCase();
}
class HeadersMock extends Appeandable {
  constructor(init) {
    super();
    if (!init)
      return;
    if (Array.isArray(init)) {
      init.forEach(([key, name]) => this.append(normalizeName(key), String(name)));
      return;
    }
    if (init instanceof HeadersMock || typeof Headers !== "undefined" && init instanceof Headers) {
      init.forEach((value, key) => this.append(normalizeName(key), String(value)));
      return;
    }
    for (const key in init) {
      this.append(normalizeName(key), String(init[key]));
    }
  }
  append(name, value) {
    super.append(normalizeName(name), String(value));
  }
  delete(name) {
    super.delete(normalizeName(name));
  }
  get(name) {
    return super.get(normalizeName(name)) ?? null;
  }
  has(name) {
    return super.has(normalizeName(name));
  }
  set(name, value) {
    super.set(normalizeName(name), String(value));
  }
}
export {
  HeadersMock
};
