import React, { isValidElement } from 'react';
import styles from '../../LegacyCard.scss.js';
import { buttonsFrom } from '../../../Button/utils.js';
import { LegacyStack } from '../../../LegacyStack/LegacyStack.js';
import { ButtonGroup } from '../../../ButtonGroup/ButtonGroup.js';
import { Text } from '../../../Text/Text.js';

function Header({
  children,
  title,
  actions
}) {
  const actionMarkup = actions ? /*#__PURE__*/React.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = /*#__PURE__*/isValidElement(title) ? title : /*#__PURE__*/React.createElement(Text, {
    variant: "headingMd",
    as: "h2"
  }, title);
  const headingMarkup = actionMarkup || children ? /*#__PURE__*/React.createElement(LegacyStack, {
    alignment: "baseline"
  }, /*#__PURE__*/React.createElement(LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children) : titleMarkup;
  return /*#__PURE__*/React.createElement("div", {
    className: styles.Header
  }, headingMarkup);
}

export { Header };
