import React from 'react';
import { ArrowLeftMinor } from '@shopify/polaris-icons';
import { handleMouseUpByBlurring } from '../../utilities/focus.js';
import styles from './Breadcrumbs.scss.js';
import { Icon } from '../Icon/Icon.js';
import { Text } from '../Text/Text.js';
import { UnstyledLink } from '../UnstyledLink/UnstyledLink.js';

function Breadcrumbs({
  breadcrumbs,
  backAction
}) {
  const breadcrumb = backAction !== null && backAction !== void 0 ? backAction : Array.isArray(breadcrumbs) ? breadcrumbs[breadcrumbs.length - 1] : breadcrumbs;

  if (breadcrumb == null) {
    if (process.env.NODE_ENV === 'development') {
      // eslint-disable-next-line no-console
      console.warn('Please provide a value to backAction, it will become required in the next major release.');
    }

    return null;
  }

  const {
    content
  } = breadcrumb;
  const contentMarkup = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("span", {
    className: styles.Icon
  }, /*#__PURE__*/React.createElement(Icon, {
    source: ArrowLeftMinor
  })), /*#__PURE__*/React.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, content));
  const breadcrumbMarkup = 'url' in breadcrumb ? /*#__PURE__*/React.createElement(UnstyledLink, {
    key: content,
    url: breadcrumb.url,
    className: styles.Breadcrumb,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": breadcrumb.accessibilityLabel
  }, contentMarkup) : /*#__PURE__*/React.createElement("button", {
    key: content,
    className: styles.Breadcrumb,
    onClick: breadcrumb.onAction,
    onMouseUp: handleMouseUpByBlurring,
    type: "button",
    "aria-label": breadcrumb.accessibilityLabel
  }, contentMarkup);
  return /*#__PURE__*/React.createElement("nav", {
    role: "navigation"
  }, breadcrumbMarkup);
}

export { Breadcrumbs };
