'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var Columns = require('../../../Columns/Columns.js');
var CloseButton = require('../CloseButton/CloseButton.js');
var Box = require('../../../Box/Box.js');
var Inline = require('../../../Inline/Inline.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Header({
  id,
  children,
  closing,
  titleHidden,
  onClose
}) {
  const titleHiddenMarkup = /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    position: "absolute",
    insetInlineEnd: "0",
    zIndex: "1"
  }, /*#__PURE__*/React__default["default"].createElement(Inline.Inline, {
    gap: "4",
    align: "end",
    blockAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(CloseButton.CloseButton, {
    titleHidden: titleHidden,
    onClick: onClose
  })));

  if (titleHidden || !children) {
    return titleHiddenMarkup;
  }

  return /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    paddingBlockStart: "4",
    paddingBlockEnd: "4",
    paddingInlineStart: "5",
    paddingInlineEnd: "5",
    borderBlockEnd: "divider"
  }, /*#__PURE__*/React__default["default"].createElement(Columns.Columns, {
    columns: {
      xs: '1fr auto'
    },
    gap: "4"
  }, /*#__PURE__*/React__default["default"].createElement(Inline.Inline, {
    gap: "4",
    blockAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    id: id,
    as: "h2",
    variant: "headingLg",
    breakWord: true
  }, children)), /*#__PURE__*/React__default["default"].createElement(CloseButton.CloseButton, {
    pressed: closing,
    titleHidden: titleHidden,
    onClick: onClose
  })));
}

exports.Header = Header;
