'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../utilities/css.js');
var Columns$1 = require('./Columns.scss.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Columns({
  children,
  columns,
  gap,
  alignItems
}) {
  const style = { ...css.getResponsiveValue('columns', 'grid-template-columns', formatColumns(columns)),
    ...css.getResponsiveProps('columns', 'gap', 'space', gap),
    '--pc-columns-align-items': alignItems
  };
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: Columns$1["default"].Columns,
    style: css.sanitizeCustomProperties(style)
  }, children);
}

function formatColumns(columns) {
  if (typeof columns === 'object' && columns !== null && !Array.isArray(columns)) {
    return Object.fromEntries(Object.entries(columns).map(([breakpointAlias, breakpointColumns]) => [breakpointAlias, getColumnValue(breakpointColumns)]));
  }

  return getColumnValue(columns);
}

function getColumnValue(columns) {
  if (!columns) return undefined;

  if (typeof columns === 'number' || !isNaN(Number(columns))) {
    return `repeat(${Number(columns)}, minmax(0, 1fr))`;
  }

  if (typeof columns === 'string') return columns;
  return columns.map(column => {
    switch (column) {
      case 'oneThird':
        return 'minmax(0, 1fr)';

      case 'oneHalf':
        return 'minmax(0, 1fr)';

      case 'twoThirds':
        return 'minmax(0, 2fr)';
    }
  }).join(' ');
}

exports.Columns = Columns;
