'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../../../utilities/css.js');
var Card = require('../../Card.scss.js');
var ButtonGroup = require('../../../ButtonGroup/ButtonGroup.js');
var utils = require('../../../Button/utils.js');
var LegacyStack = require('../../../LegacyStack/LegacyStack.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

/** @deprecated Use LegacyCard or AlphaCard instead. */
function Section({
  children,
  title,
  subdued,
  flush,
  fullWidth,
  actions,
  hideOnPrint
}) {
  if (process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: <Card /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyCard /> or <AlphaCard /> instead.');
  }

  const className = css.classNames(Card["default"].Section, flush && Card["default"]['Section-flush'], subdued && Card["default"]['Section-subdued'], fullWidth && Card["default"]['Section-fullWidth'], hideOnPrint && Card["default"]['Section-hideOnPrint']);
  const actionMarkup = actions ? /*#__PURE__*/React__default["default"].createElement(ButtonGroup.ButtonGroup, null, utils.buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = typeof title === 'string' ? /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    variant: "headingSm",
    as: "h3"
  }, title) : title;
  const titleAreaMarkup = titleMarkup || actionMarkup ? /*#__PURE__*/React__default["default"].createElement("div", {
    className: Card["default"].SectionHeader
  }, actionMarkup ? /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack, {
    alignment: "baseline"
  }, /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup) : titleMarkup) : null;
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: className
  }, titleAreaMarkup, children);
}

exports.Section = Section;
