'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var Card = require('../../Card.scss.js');
var ButtonGroup = require('../../../ButtonGroup/ButtonGroup.js');
var utils = require('../../../Button/utils.js');
var LegacyStack = require('../../../LegacyStack/LegacyStack.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

/** @deprecated Use LegacyCard or AlphaCard instead. */
function Header({
  children,
  title,
  actions
}) {
  if (process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: <Card /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyCard /> or <AlphaCard /> instead.');
  }

  const actionMarkup = actions ? /*#__PURE__*/React__default["default"].createElement(ButtonGroup.ButtonGroup, null, utils.buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = /*#__PURE__*/React.isValidElement(title) ? title : /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    variant: "headingMd",
    as: "h2"
  }, title);
  const headingMarkup = actionMarkup || children ? /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack, {
    alignment: "baseline"
  }, /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children) : titleMarkup;
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: Card["default"].Header
  }, headingMarkup);
}

exports.Header = Header;
