"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApp = void 0;
var validate_1 = __importDefault(require("./validate"));
var utils_1 = require("./validate/utils");
var redirect_1 = require("./client/redirect");
var client_1 = require("./client");
var shared_1 = require("./util/shared");
/**
 * Creates your application instance with validator middleware.
 * @param config - `apiKey` and `host` are both required.
 * @remarks
 * Please note that `forceRedirect` only works in production environment (`shopname.myshopify.com/admin`).
 * You will need to store `host` during the authentication process and then retrieve it for the code to
 * work properly. To learn more about this process, see
 * {@link https://help.shopify.com/api/embedded-apps/shop-origin | Getting and storing the shop origin}.
 * @public
 */
function createApp(config) {
    var currentWindow = redirect_1.getWindow();
    if (!currentWindow || !currentWindow.top) {
        return shared_1.serverAppBridge;
    }
    utils_1.mixedAppClientCheck(currentWindow);
    return client_1.createAppWrapper(currentWindow.top, currentWindow.location.origin, [validate_1.default])(config);
}
exports.createApp = createApp;
exports.default = createApp;
__exportStar(require("./MessageTransport"), exports);
__exportStar(require("./client"), exports);
