import type { FeaturePermission, FeaturesAction } from '@shopify/app-bridge';
import { Group } from '@shopify/app-bridge/actions';
/**
 * useFeatureRequest hook
 *
 * @public
 * @remarks
 * React hook performs a feature request and then returns
 * the requested feature when permissions has been updated
 * @param {Group} group - The requested group enum
 * @param {string} action - The requested action. This param is optional
 */
export declare function useFeatureRequest(group: Group, action?: string): FeaturesAction | FeaturePermission | undefined;
