import { ActionProps, ActionGroupProps, Target } from '../../types';
export interface Breadcrumb {
    /** Content the action displays */
    content?: string;
    /** A destination to link to */
    url?: string;
    /**
     * Where to display the target link
     * @default 'APP'
     */
    target?: Target;
    /** Callback when an action takes place */
    onAction?(): void;
}
export interface Props {
    /** TitleBar title */
    title: string;
    /** The current breadcrumb; only displays the last item in array */
    breadcrumbs?: Breadcrumb | Breadcrumb[];
    /** Primary TitleBar action */
    primaryAction?: ActionProps;
    /** Collection of secondary TitleBar actions */
    secondaryActions?: ActionProps[];
    /** Collection of TitleBar groups of secondary actions */
    actionGroups?: ActionGroupProps[];
}
export default function TitleBar(props: Props): null;
