export interface ErrorMessageCallback {
    (error: string, value: any): string | undefined;
}
export interface Options {
    message?: string | ErrorMessageCallback;
}
export declare type Schema<TMap extends Object = {}> = {
    [key in keyof TMap]-?: Validator;
};
export declare const TYPE_ERROR = "type_error_expected";
export interface Indexable {
    [key: string]: any;
}
export interface ValidationError {
    error: string;
    message?: string;
    path?: string;
    value: any;
}
export interface Validator {
    (value: any): ValidationError[] | undefined;
}
export declare function composeSchemas(...validators: Validator[]): Validator;
/**
 * Returns a validator that matches values in the given enum
 * @param type - enum to use for match values
 * @public
 */
export declare function matchesEnum(types: Indexable, options?: Options): Validator;
export declare function matchesArray(validator?: Validator, options?: Options): Validator;
export declare function oneOf(...validators: Validator[]): Validator;
export declare function getErrors(obj: any, validator: Validator, key?: string): {
    path: string | undefined;
    error: string;
    message?: string | undefined;
    value: any;
}[] | undefined;
export declare function matchesObject<TSchema extends Object = any>(schema: Schema<TSchema>, options?: Options): Validator;
export declare function matchesString(options?: Options): Validator;
export declare function makeOptional(validator: Validator): (value: any) => ValidationError[] | undefined;
export declare function matchesBoolean(options?: Options): Validator;
export declare function matchesPositiveInteger(options?: Options): Validator;
export declare function validate(obj: any, validator: Validator): {
    path: string | undefined;
    error: string;
    message?: string | undefined;
    value: any;
}[] | undefined;
