import {FormLayout, Layout, TextField, Form, Button, SkeletonBodyText, Text, LegacyStack, Page, AlphaStack, Divider, Card, TextStyle, LegacyCard, Image} from '@shopify/polaris';
import React from 'react';
import {useState, useCallback, useEffect} from 'react';
import { Toast } from "@shopify/app-bridge-react";

export function UserThemeSteps() {
  
  const emptyToastProps = { content: null };
  const [toastProps, setToastProps] = useState(emptyToastProps);

  const toastMarkup = toastProps.content && (
    <Toast {...toastProps} onDismiss={() => setToastProps(emptyToastProps)} />
  );

  var fileurl = 'https://app.personalisedgiftsupply.co.uk/Manual-Installation.pdf';
  var cssfileurl = 'https://app.personalisedgiftsupply.co.uk/pgs-app/files/pgs-custom.css';
  var jsfileurl = 'https://app.personalisedgiftsupply.co.uk/pgs-app/files/pgs-custom.js';
  var liquidfileurl = 'https://app.personalisedgiftsupply.co.uk/pgs-app/files/personalised-gift-supply.liquid';

  return (
    <>
    {toastMarkup}
    <Card sectioned title="App Steps">
        <Page fullWidth>
            <div className="faq_wrap">
                <Card sectioned>
                    <Text variant="headingXl" as="p">Manual Install via App Widget Block (Online Store 2.0 Themes)</Text>
                    <br />
                    <Text variant="headingMd" as="p">
                        If your theme is compatible with online store 2.0 then please follow these steps to setup: 
                    </Text>
                    <br />
                    <Text variant="headingMd" as="p">
                        <strong> Step 1) </strong> Select the theme in that you want to apply this app functionality. Click on the Customize button.
                    </Text>
                    <br />

                    <Layout>
                        <Layout.Section oneThird>
                          <LegacyCard title="">
                            <LegacyCard.Section>
                              <div class="banner-container">
                                    <Image
                                        source="https://app.personalisedgiftsupply.co.uk/pgs-app/extension-steps-images/app-blocks-step1-image.png"
                                        alt="Step 1 Image"
                                        style={{ width: "100%", overflowX: "hidden" }}
                                    />
                              </div>
                            </LegacyCard.Section>
                          </LegacyCard>
                        </Layout.Section>
                    </Layout>

                    <br />

                    <Text variant="headingMd" as="p">
                        <strong>Step 2) </strong> Click on the "App embeds" icon and then check whether the PGS app is enabled If not then please enable this and save it.
                    </Text>
                    <br />

                    <Layout>
                        <Layout.Section oneThird>
                          <LegacyCard title="">
                            <LegacyCard.Section>
                              <div class="banner-container">
                                    <Image
                                        source="https://app.personalisedgiftsupply.co.uk/pgs-app/extension-steps-images/app-blocks-step2a-image.png"
                                        alt="Step 2 Image1"
                                        style={{ width: "100%", overflowX: "hidden" }}
                                    />
                              </div>
                            </LegacyCard.Section>
                          </LegacyCard>
                        </Layout.Section>
                    </Layout>

                    <br />
                    <Layout>
                        <Layout.Section oneThird>
                          <LegacyCard title="">
                            <LegacyCard.Section>
                              <div class="banner-container">
                                    <Image
                                        source="https://app.personalisedgiftsupply.co.uk/pgs-app/extension-steps-images/app-blocks-step2b-image.png"
                                        alt="Step 2 Image2"
                                        style={{ width: "100%", overflowX: "hidden" }}
                                    />
                              </div>
                            </LegacyCard.Section>
                          </LegacyCard>
                        </Layout.Section>
                    </Layout>
                
                    <br />
                    <Text variant="headingMd" as="p">
                        <strong> Step 3) </strong> Navigate to the product page, add the app block from the PGS app. To do this, click on the "Add block" button, add the PGS app block and then click save.
                    </Text>

                    <br />

                    <Layout>
                        <Layout.Section oneThird>
                          <LegacyCard title="">
                            <LegacyCard.Section>
                              <div class="banner-container">
                                    <Image
                                        source="https://app.personalisedgiftsupply.co.uk/pgs-app/extension-steps-images/app-blocks-step3a-image.png"
                                        alt="Step 3 Image1"
                                        style={{ width: "100%", overflowX: "hidden" }}
                                    />
                              </div>
                            </LegacyCard.Section>
                          </LegacyCard>
                        </Layout.Section>
                    </Layout>

                    <br />
                    <Layout>
                        <Layout.Section oneThird>
                          <LegacyCard title="">
                            <LegacyCard.Section>
                              <div class="banner-container">
                                    <Image
                                        source="https://app.personalisedgiftsupply.co.uk/pgs-app/extension-steps-images/app-blocks-step3b-image.png"
                                        alt="Step 3 Image2"
                                        style={{ width: "100%", overflowX: "hidden" }}
                                    />
                              </div>
                            </LegacyCard.Section>
                          </LegacyCard>
                        </Layout.Section>
                    </Layout>
                    
                    <br />
                    <Layout>
                        <Layout.Section oneThird>
                          <LegacyCard title="">
                            <LegacyCard.Section>
                              <div class="banner-container">
                                    <Image
                                        source="https://app.personalisedgiftsupply.co.uk/pgs-app/extension-steps-images/app-blocks-step3c-image.png"
                                        alt="Step 3 Image3"
                                        style={{ width: "100%", overflowX: "hidden" }}
                                    />
                              </div>
                            </LegacyCard.Section>
                          </LegacyCard>
                        </Layout.Section>
                    </Layout>
                    <br />

                </Card>

                <Card sectioned>
                    <Text variant="headingXl" as="p">
                        Manual Install (Vintage Themes) 
                    </Text>
                    <br />
                    <Text variant="headingMd" as="p">
                        You can use personalised gift supply app on the store using installation guide. Please use this link &nbsp;
                        <br />
                        <a href={fileurl} target="_blank">
                            Installtion guide
                        </a>
                        <br />
                        Download CSS File -  <a href={cssfileurl} target="_blank">PGS Custom CSS File </a>
                        <br />
                        Download Js File -  <a href={jsfileurl} target="_blank">PGS Custom JS File </a>
                        <br />
                        Download Liquid File -  <a href={liquidfileurl} target="_blank">Liquid File </a>
                        <br />
                        <br />
                    </Text>
                </Card>

            </div>
        </Page>
    </Card>
    </>
  );  

}