import { FormLayout, TextField, Form, InlineError, Button, SkeletonBodyText, AlphaStack, Page, Link, Text, Badge, LegacyCard, LegacyStack, Columns, AlphaCard} from '@shopify/polaris';
import React from 'react';
import { useState, useCallback, useEffect } from 'react';
import { useAuthenticatedFetch } from "../hooks";
import { Toast } from "@shopify/app-bridge-react";
import ThemeVerifyStatus from "./ThemeVerifyStatus";

export function UserSettingForm() {

  const emptyToastProps = { content: null };
  const [isLoading, setIsLoading] = useState(false);
  const [isSyncDataLoading, setIsSyncDataLoading] = useState(false);
  const [pageLoader, setPageLoader] = useState(true);
  const [toastProps, setToastProps] = useState(emptyToastProps);

  const [isSyncPgsFontsDataLoading, setIsSyncPgsFontsDataLoading] = useState(false);

  const [isSyncPgsClipartsDataLoading, setIsSyncPgsClipartsDataLoading] = useState(false);

  const customFetch = useAuthenticatedFetch();

  const [isSubmited, setIsSubmited] = useState(false);

  const [username, setUsername] = useState('');

  const [pgsAppStatus, setPgsAppStatus] = useState('');

  const [pgsAppMessage, setPgsAppMessage] = useState('');

  const [pgsAppFonts, setPgsAppFonts] = useState('');

  const [pgsAppCliparts, setPgsAppCliparts] = useState('');

  const [sendPgsAppFonts, setSendPgsAppFonts] = useState('');

  const [sendPgsAppCliparts, setSendPgsAppCliparts] = useState('');

  const [apikey, setApiKey] = useState('');

  const [shopifyThemeStatus, setShopifyThemeStatus] = useState('');

  useEffect(() => {
    getUserData();
  }, []);

  const getUserData = async () => {
    // const form=document.querySelector('#userSetting');
    setPageLoader(true);

    const response = await customFetch("/api/get-user-settings").then(res => {
      return res.json();
    });

    if (response.status) {
      console.log("response - ", response.data);

      if (response.data.username && response.data.username.length > 0) {
        setUsername(response.data.username);
      } 

      if (response.data.api_key && response.data.api_key.length > 0) {
        setApiKey(response.data.api_key);
      } 

      setPgsAppStatus(response.data.pgs_app_status);
      setPgsAppMessage(response.data.pgs_app_status_message);
      setPgsAppFonts(response.data.total_pgs_fonts);
      setPgsAppCliparts(response.data.total_pgs_cliparts);
      setSendPgsAppFonts(response.data.send_shopify_pgs_fonts);
      setSendPgsAppCliparts(response.data.send_shopify_pgs_cliparts);
      setShopifyThemeStatus(response.theme_status);
      setPageLoader(false);
      
    }else{
      setPageLoader(false);
    }

  };

  const handleSubmit = async (type) => {
    
    // console.log("username", username);
    // console.log("apikey", apikey);
    setIsSubmited(true);

    if(username.length != 0 && apikey.length != 0){
        // const form=document.querySelector('#userSetting');
        if(type == 'submit'){
          setIsLoading(true);
        }else{
          setIsSyncDataLoading(true);
        }
       
        const formData = new FormData();
        formData.append("username", username);
        formData.append("apikey", apikey);
        formData.append("type", type);

        const response = await customFetch("/api/update-user-settings", {
          method: 'POST', // *GET, POST, PUT, DELETE, etc.       
          body: formData // body data type must match "Content-Type" header
        }).then(res => {
          return res.json();
        });

        if (response.status) {
          // console.log(response);     
          setUsername(response.data.username);
          setApiKey(response.data.api_key);
          setPgsAppStatus(response.data.pgs_app_status);
          setPgsAppMessage(response.data.pgs_app_status_message);
          setPgsAppFonts(response.data.total_pgs_fonts);
          setPgsAppCliparts(response.data.total_pgs_cliparts);
          setSendPgsAppFonts(response.data.send_shopify_pgs_fonts);
          setSendPgsAppCliparts(response.data.send_shopify_pgs_cliparts);
          setToastProps({ content: response.message });
          setIsLoading(false);
          setIsSyncDataLoading(false);
        } else {
          setIsLoading(false);
          setIsSyncDataLoading(false);
          setToastProps({
            content: response.message,
            error: true,
          });
        }
    }
  };

  const createShopifyFile = async (type) => {

    if(type == 'fonts'){
      setIsSyncPgsFontsDataLoading(true);
    }else{
      setIsSyncPgsClipartsDataLoading(true);
    }

    const formData = new FormData();
    formData.append("type", type);

    const response = await customFetch("/api/create-shopify-files", {
      method: 'POST', // *GET, POST, PUT, DELETE, etc.       
      body: formData // body data type must match "Content-Type" header
    }).then(res => {
      return res.json();
    });

    if (response.status) {
      // console.log(response);     
      setToastProps({ content: response.message });
      setPgsAppFonts(response.data.total_pgs_fonts);
      setPgsAppStatus(response.data.pgs_app_status);
      setPgsAppCliparts(response.data.total_pgs_cliparts);
      setSendPgsAppFonts(response.data.send_shopify_pgs_fonts);
      setSendPgsAppCliparts(response.data.send_shopify_pgs_cliparts);
      setIsSyncPgsFontsDataLoading(false);
      setIsSyncPgsClipartsDataLoading(false);
      getUserData();
    } else {
      setIsSyncPgsFontsDataLoading(false);
      setIsSyncPgsClipartsDataLoading(false);
      setToastProps({
        content: response.message,
        error: true,
      });
    }
  };

  const handleUsernameChange = useCallback((username) => setUsername(username), []);

  const handleApiKeyChange = useCallback((apikey) => setApiKey(apikey), []);

  const toastMarkup = toastProps.content && (
    <Toast {...toastProps} onDismiss={() => setToastProps(emptyToastProps)} />
  );

  return (
    <>
      {toastMarkup}
      {pageLoader ? <SkeletonBodyText /> :
        shopifyThemeStatus ?
          <Page fullWidth>
          <LegacyCard sectioned title="Settings">
            <Form noValidate id="userSetting">
              <FormLayout>
                  <AlphaStack gap="3">
                      <TextField value={username} label="Username" onChange={handleUsernameChange} autoComplete="off" />
                      {isSubmited && username.length == 0
                      ? (
                            <InlineError
                              message="Please enter username"
                              fieldID="myFieldID"
                            />
                          ) : null}
                      <TextField
                        value={apikey}
                        label="Api Key"
                        onChange={handleApiKeyChange}
                        multiline={4}
                        autoComplete="off"
                      />
                      {isSubmited && apikey.length == 0
                      ? (
                            <InlineError
                              message="Please enter apikey"
                              fieldID="myFieldID"
                            />
                          ) : null}
                  </AlphaStack>
                  <Button loading={isLoading} onClick={() => handleSubmit('submit')}>Submit</Button>
                  <Badge status={pgsAppStatus}>{pgsAppMessage}</Badge>
                  <Text as="p" fontWeight="regular">
                    Please contact us on <Link url="mailto:sales@personalisedgiftsupply.com">sales@personalisedgiftsupply.com</Link> for your API key.
                  </Text>
              </FormLayout>
            </Form>
          </LegacyCard>
          {
            (pgsAppStatus == 'success') ? 
              <>
              <LegacyCard sectioned title="Sync Data">
                <AlphaStack gap="4" >
                  <Columns gap="4" columns={6}>
                    <Button primary size="micro" loading={isSyncDataLoading} onClick={() => handleSubmit('sync_data')}>Sync fonts & cliparts data</Button>
                  </Columns>
                  <Text as="p" fontWeight="regular">
                    By Clicking on the Sync Data button, syncing fonts, cliparts from the PGS App.
                  </Text>

                  {/* <Columns gap="4" columns={2}>
                    {
                      (pgsAppFonts > 0) ?
                        <>
                          <AlphaCard>
                            <AlphaStack>
                              <Text as="p" fontWeight="regular">
                                Total create shopify font files {sendPgsAppFonts} out of {pgsAppFonts}.
                              </Text>
                                <Button primary loading={isSyncPgsFontsDataLoading} onClick={() => createShopifyFile('fonts')}>Create fonts file on the store</Button>
                            </AlphaStack>
                          </AlphaCard>
                        </>
                      :
                      <></>
                    }

                    {
                      (pgsAppCliparts > 0) ?
                        <>
                          <AlphaCard>
                            <AlphaStack>
                              <Text as="p" fontWeight="regular">
                                Total create shopify clipart files {sendPgsAppCliparts} out of {pgsAppCliparts}.
                              </Text>
                              <Button primary loading={isSyncPgsClipartsDataLoading} onClick={() => createShopifyFile('cliparts')}>Create cliparts file on the store</Button>
                            </AlphaStack>
                          </AlphaCard>
                        </>
                      :
                      <></>
                    }
                  </Columns> */}

                </AlphaStack>
              </LegacyCard>
              </>
            : 
            <></>
          }
        </Page>
        :
          <><ThemeVerifyStatus /></>       
      }
    </>
  );
}