import { FormLayout, TextField, Form, Button, SkeletonBodyText, Text, Page, AlphaStack, Divider, Card, LegacyCard, LegacyStack, Collapsible, TextContainer, Link, Icon, Checkbox, RadioButton, Select, ChoiceList,AlphaCard, Columns } from '@shopify/polaris';
import React from 'react';
import { useState, useCallback, useEffect } from 'react';
import { useAuthenticatedFetch } from "../hooks";
import { Toast } from "@shopify/app-bridge-react";
import { MobileCancelMajor, MobilePlusMajor } from '@shopify/polaris-icons';
import ThemeVerifyStatus from "./ThemeVerifyStatus";

export function UserOrderSetting() {

    const emptyToastProps = { content: null };

    const [isLoading, setIsLoading] = useState(false);

    const [pageLoader, setPageLoader] = useState(true);

    const [toastProps, setToastProps] = useState(emptyToastProps);

    const customFetch = useAuthenticatedFetch();
    
    const [marginChange, setMarginChange] = useState('');
    
    const [automatedJobStatus, setAutomatedJobStatus] = useState('');

    const [deductPriceChange, setDeductPriceChange] = useState('');

    // const [syncTypeValue, setSyncTypeValue] = useState(['manually_synchronize']);
    
    const [nextDayShippingValue, setNextDayShippingValue] = useState(['']);

    const [automaticallyProcessOrder, setAutomaticallyProcessOrders] = useState('');

    const [processSharedOrder, setProcessSharedOrders] = useState('');

    const [importCategory, setImportCategory] = useState('');

    const [importAll, setImportAll] = useState('');
    
    const [personalisedButtonPosition, setPersonalisedButtonPosition] = useState('');
    
    const [personalisedButtonSelector, setPersonalisedButtonSelector] = useState('');
    
    const [productRange, setProductRange] = useState([]);

    const [selectedPricingOptions, setSelectedPricingOptions] = useState('set_own_price');

    const [shopifyThemeStatus, setShopifyThemeStatus] = useState('');

    const handleSelectChange = useCallback((selectedPricingOptions) => setSelectedPricingOptions(selectedPricingOptions), []);

    const handleMarginChange = useCallback((marginChange) => setMarginChange(marginChange), []);
    
    const handlePersonalisedButtonSelector = useCallback((personalisedButtonSelector) => setPersonalisedButtonSelector(personalisedButtonSelector), []);

    const handleDuductPriceChange = useCallback((deductPriceChange) => setDeductPriceChange(deductPriceChange), []);

    const handleAutomaticOrder = useCallback((automaticallyProcessOrder) => setAutomaticallyProcessOrders(automaticallyProcessOrder), []);

    const handleSharedOrder = useCallback((processSharedOrder) => setProcessSharedOrders(processSharedOrder), []);

    const handleImportCategory = useCallback((importCategory) => setImportCategory(importCategory), []);

    const handleImportAll = useCallback((importAll) => setImportAll(importAll), []);
    
    const handlePersonalisedButtonPosition = useCallback((personalisedButtonPosition) => setPersonalisedButtonPosition(personalisedButtonPosition), []);

    const handleProductRanges = useCallback((productRange) => setProductRange(productRange), []);
    
    const handleNextDayShippingType = useCallback((nextDayShippingValue) => setNextDayShippingValue(nextDayShippingValue), []);

    // const handleSynchroniseType = useCallback((_, syncTypeValue) => setSyncTypeValue(syncTypeValue), []); 

    // const handleSynchroniseType = useCallback((syncTypeValue) => setSyncTypeValue(syncTypeValue), []); 

    useEffect(() => {
        getOrderSettingData();
    }, []);

    const getOrderSettingData = async () => {

        setPageLoader(true);
        const response = await customFetch("/api/get-order-setting").then(res => {
            return res.json();
        });

        if (response.status) {
            // console.log("data", response.data);
            if (response.data.price_range_values && response.data.price_range_values.length > 0) {
                setProductRange(response.data.price_range_values.split(","));
            } 
            // setSyncTypeValue([response.data.sync_type_value]);
            setNextDayShippingValue([response.data.next_day_shipping_type_value]);
            setAutomaticallyProcessOrders(response.data.automatically_process_order);
            setProcessSharedOrders(response.data.process_shared_order);
            setImportCategory(response.data.import_category);
            setImportAll(response.data.import_all);
            setPersonalisedButtonPosition(response.data.set_personalised_button_position);
            setPersonalisedButtonSelector(response.data.set_personalised_button_selector);
            setSelectedPricingOptions(response.data.pricing_options);
            setDeductPriceChange(response.data.deduct_price_change);
            setMarginChange(response.data.margin_change);
            setAutomatedJobStatus(response.data.automated_job_status);
            setShopifyThemeStatus(response.theme_status);
            setPageLoader(false);

        } else {
            setPageLoader(false);
        }
    };
    
    const handleOrderSettingFormSubmit = async (type) => {

        setIsLoading(true);
        const formData = new FormData();
        // formData.append("sync_type_value", syncTypeValue);
        formData.append("next_day_shipping_type_value", nextDayShippingValue);
        formData.append("automatically_process_order", automaticallyProcessOrder);
        formData.append("process_shared_order", processSharedOrder);
        formData.append("import_category", importCategory);
        formData.append("import_all", importAll);
        formData.append("set_personalised_button_position", personalisedButtonPosition);
        formData.append("set_personalised_button_selector", personalisedButtonSelector);
        formData.append("pricing_options", selectedPricingOptions);
        formData.append("margin_change", marginChange);
        formData.append("deduct_price_change", deductPriceChange);
        formData.append("price_range_values", productRange);

        const response = await customFetch("/api/update-order-settings", {
            method: 'POST', // *GET, POST, PUT, DELETE, etc.       
            body: formData // body data type must match "Content-Type" header
        }).then(res => {
            return res.json();
        });

        if (response.status) {  

            if (response.data.price_range_values && response.data.price_range_values.length > 0) {
                setProductRange(response.data.price_range_values.split(","));
            }
            // setSyncTypeValue([response.data.sync_type_value]);
            setNextDayShippingValue([response.data.next_day_shipping_type_value]);
            setAutomaticallyProcessOrders(response.data.automatically_process_order);
            setProcessSharedOrders(response.data.process_shared_order);
            setImportCategory(response.data.import_category);
            setImportAll(response.data.import_all);
            setPersonalisedButtonPosition(response.data.set_personalised_button_position);
            setPersonalisedButtonSelector(response.data.set_personalised_button_selector);
            setSelectedPricingOptions(response.data.pricing_options);
            setDeductPriceChange(response.data.deduct_price_change);
            setMarginChange(response.data.margin_change);
            setToastProps({ content: response.message });
            setIsLoading(false);
            getOrderSettingData();
            
        } else {
            setIsLoading(false);
            setToastProps({
                content: response.message,
                error: true,
            });
        }
    };

    const pricingoptions = [
        {label: 'Set my own pricing', value: 'set_own_price'},
        {label: 'Suggested RRP', value: 'suggested_rrp'},
        {label: 'Custom Markup', value: 'custom_margin'},
    ];

    const toastMarkup = toastProps.content && (
        <Toast {...toastProps} onDismiss={() => setToastProps(emptyToastProps)} />
    );

    // console.log(shopifyThemeStatus);
    return (
        <>
            {toastMarkup}
            {pageLoader ? <SkeletonBodyText /> :
                shopifyThemeStatus ?
                    <Card sectioned title="">
                        <Page fullWidth>
                            <Form>
                                <FormLayout>
                                <LegacyStack vertical>

                                    {/* <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Order Synchronize Type
                                        </Text>
                                        <p>Use "manually synchronised" to sync orders manually with Personalised Gift Supply, this is used if you want to send all orders at the end of each day.</p>
                                        <p>Synchronise when order status change will update orders to processed when they're dispatched from Personalised Gift Supply</p>
                                    </TextContainer>

                                    <ChoiceList
                                        title=""
                                        choices={[
                                            {label: 'Manually Synchronize', value: 'manually_synchronize'},
                                            {label: 'Synchronize When Order Status Change', value: 'order_status_change'},
                                        ]}
                                        selected={syncTypeValue}
                                        onChange={handleSynchroniseType}
                                    /> */}

                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Automatically Process Orders
                                        </Text>
                                        <p>If this is ticked your orders will automatically be updated to completed once the order has been dispatched from Personalised Gift Supply.</p>
                                    </TextContainer>

                                    <Checkbox
                                        label="Automictically Process Orders"
                                        checked={automaticallyProcessOrder}
                                        onChange={handleAutomaticOrder}
                                    />
                                    
                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Next Day Shipping
                                        </Text>
                                        <p>When this is enabled if you charge shipping cost the order will be marked as paid shipping and upgraded to next day delivery, this will incur a charge on your account.</p>
                                    </TextContainer>

                                    <ChoiceList
                                        title=""
                                        choices={[
                                            {label: 'Enable next day shipping', value: 'enable_next_day_shipping'},
                                            {label: 'Upgrade all orders to next day regardless of shipping cost', value: 'all_orders_to_next_day'},
                                            {label: 'Disable next day shipping', value: 'disable_next_day_shipping'},
                                        ]}
                                        selected={nextDayShippingValue}
                                        onChange={handleNextDayShippingType}
                                    />

                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Process Shared Orders
                                        </Text>
                                        <p>By default this is unticked, if you sell a mix of our products and your own, when ticked this will mark the order as complete once we have processed the order from our side</p>
                                    </TextContainer>

                                    <Checkbox
                                    label="Automatically process mixed orders"
                                    checked={processSharedOrder}
                                    onChange={handleSharedOrder}
                                    />

                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Import Category/Collections?
                                        </Text>
                                        <p>When enabled this will import our recommended categories and collections into your site and list products into those categories/collections.</p>
                                    </TextContainer>

                                    <Checkbox
                                        label="Enabled"
                                        checked={importCategory}
                                        onChange={handleImportCategory}
                                    />

                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                        Product Ranges
                                        </Text>
                                        <p>Please check the product ranges that you would like to be displayed on your website.</p>
                                    </TextContainer>

                                    <ChoiceList
                                        allowMultiple
                                        title=""
                                        choices={[
                                            {
                                            label: 'Personalised Products',
                                            value: 'personalised_products',
                                            },
                                            {
                                            label: 'Decorated Glassware',
                                            value: 'decorated_glassware',
                                            },
                                            {
                                            label: 'Engraved Trophies',
                                            value: 'engraved_trophies',
                                            },
                                            {
                                            label: 'Say it with glass',
                                            value: 'say_it_with_glass',
                                            },
                                        ]}
                                        selected={productRange}
                                        onChange={handleProductRanges}
                                    />

                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Import All
                                        </Text>
                                        <p>When this option is ticked all available products from the product ranges selected will be imported into your store and new products will automatically be added.</p>
                                    </TextContainer>

                                    <Checkbox
                                    label="Import All"
                                    checked={importAll}
                                    onChange={handleImportAll}
                                    />
                                    
                                    {/* <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                            Add personalise button on specific position using add selector values
                                        </Text>
                                    </TextContainer>

                                    <Checkbox
                                    label="Personalised Button Position"
                                    checked={personalisedButtonPosition}
                                    onChange={handlePersonalisedButtonPosition}
                                    />
                                    
                                    { (personalisedButtonPosition === true)
                                        ?  
                                        <>
                                            <Columns gap="4" columns={1}>
                                                <AlphaStack>
                                                    <TextField
                                                        label="Personalised Button Position Selector"
                                                        value={personalisedButtonSelector}
                                                        onChange={handlePersonalisedButtonSelector}
                                                        autoComplete="off"
                                                    />
                                                </AlphaStack>
                                            </Columns> 
                                        </>
                                        :
                                        <></>
                                    }
                                    */}
                                    <TextContainer spacing="loose">
                                        <Text variant="headingMd" as="h2">
                                        Pricing ?
                                        </Text>
                                        <p>Here you're able to state how you would like your products priced.</p>
                                        <p>Set my own pricing - Will initially pull our RRP but you're then able to manually set each product to the price you would like</p>
                                        <p>Suggested RRP - This will use our RRP and continually update the RRP as products become cheaper or more expensive your RRP will fluctuate up and down.</p>
                                        <p>Custom Markup - This will allow you to set your own markup, after this has been selected you will need to click save which will enable two extra fields "Markup" and "Deduct from pricing" once your markup has been set your products will be rounded up to the nearest pound you can then set the value you wish to deduct from the price, for example you wish for your products to round to the nearest 99p you would select 0.01 in this field.</p>
                                    </TextContainer>

                                    <Select
                                    label=""
                                    options={pricingoptions}
                                    onChange={handleSelectChange}
                                    value={selectedPricingOptions}
                                    />

                                    { (selectedPricingOptions === 'custom_margin')
                                        ?  
                                        <>
                                            <Columns gap="4" columns={2}>
                                                <AlphaStack>
                                                    <TextField
                                                        label="Markup in %"
                                                        value={marginChange}
                                                        type="number"
                                                        onChange={handleMarginChange}
                                                        autoComplete="off"
                                                    />
                                                </AlphaStack>

                                                <AlphaStack>
                                                    <TextField
                                                        label="Deduct from pricing :"
                                                        value={deductPriceChange}
                                                        type="number"
                                                        onChange={handleDuductPriceChange}
                                                        autoComplete="off"
                                                    />
                                                </AlphaStack>
                                            </Columns> 
                                        </>
                                        :
                                        <></>
                                    }
                                    
                                    { (automatedJobStatus === 0) ?
                                        <>
                                            <Button primary loading={isLoading} onClick={() => handleOrderSettingFormSubmit()}>Save Settings</Button>
                                        </>
                                        :
                                        <>
                                            <Button primary disabled>
                                                Sync is currently running, please try again shortly.
                                            </Button>
                                        </>
                                    }
                                    </LegacyStack>
                                </FormLayout>
                            </Form>
                        </Page>
                    </Card>
                :
                    <><ThemeVerifyStatus /></>                 
            }
        </>
    );

}