import {FormLayout, TextField, Form, Button, SkeletonBodyText, Text, LegacyStack, Page, AlphaStack, Divider, Card} from '@shopify/polaris';
import React from 'react';
import {useState, useCallback, useEffect} from 'react';
import { useAuthenticatedFetch } from "../hooks";
import { Toast } from "@shopify/app-bridge-react";
import ThemeVerifyStatus from "./ThemeVerifyStatus";

export function UserHowToPage() {
  
  const emptyToastProps = { content: null };
  const [isLoading, setIsLoading] = useState(false);
  const [pageLoader, setPageLoader] = useState(true);
  const [toastProps, setToastProps] = useState(emptyToastProps);
  const [pageContentData, setPageContentData] = useState([]);
  const [pageTitle, setPageTitle] = useState([]);
  const [pageVideoLink, setPageVideoLink] = useState([]);
  const [shopifyThemeStatus, setShopifyThemeStatus] = useState('');

  const customFetch = useAuthenticatedFetch();

  useEffect(() => {
    getHowToPageData();
  }, []);

  const getHowToPageData = async () => {
    setPageLoader(true);

    const response = await customFetch("/api/get-how-to-page-contents").then(res => {
      return res.json();
    });

    if (response.status) {
      setPageContentData(response.data);
      setPageTitle(response.page_title);
      setPageVideoLink(response.video_link);
      setShopifyThemeStatus(response.theme_status);
      setPageLoader(false);
      
    }else{
      setPageLoader(false);
    }

  };

  const toastMarkup = toastProps.content && (
    <Toast {...toastProps} onDismiss={() => setToastProps(emptyToastProps)} />
  );

  return (
    <>
    {toastMarkup}
    {pageLoader ? <SkeletonBodyText /> :
        shopifyThemeStatus ?
          <Card sectioned title={pageTitle}>
          <Page fullWidth>
              <AlphaStack gap="025" inlineAlign="center">
                {pageVideoLink ? 
                    <iframe width="640" height="480" src={pageVideoLink} title="PGS Plugin Video" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                  : '' }
              </AlphaStack>
              <br /> <br />
              <LegacyStack vertical>

              {pageContentData.map((content) => (
              <>
                <Text as="p" fontWeight="bold">
                  {content?.step}
                </Text>
                <br />
                <Text as="p" fontWeight="regular">
                  {content?.description}
                </Text>
                </>
              ))}

              </LegacyStack>
              </Page>
            </Card>
        : 
          <><ThemeVerifyStatus /></>
      }
    </>
  );  

}