import React, { useState, useCallback, useEffect }from 'react';
import {
  Card,
  Page,
  EmptyState,
  Layout,
  TextContainer,
  SkeletonBodyText,
  Image,
  Stack,
  Link,
  Heading,
  Button,
  CalloutCard,
  Loading,
  Frame,
} from "@shopify/polaris";
import { TitleBar } from "@shopify/app-bridge-react";

export default function ThemeVerifyStatus() {

  const title = (
    <>
      <TextContainer>
        <p>
          It looks like your theme does not fully support the functionality of
          this app.
        </p>
        <p>
          Try switching to a different theme or contacting your theme developer
          to request support.
        </p>
      </TextContainer>
    </>
  );

  return (

    <Page fullWidth>
      <TitleBar title="Personalised Gift Supply" primaryAction={null} />
      <Layout>
        <Layout.Section>
            <Card sectioned>
                <Stack
                wrap={false}
                spacing="extraTight"
                distribution="trailing"
                alignment="center"
                >
                <Stack.Item fill>
                <Page narrowWidth>
                    <CalloutCard
                        title={title}
                        illustration="https://cdn.shopify.com/s/assets/admin/checkout/settings-customizecart-705f57c725ac05be5a34ec20c05b94298cb8afd10aac7bd9c7ad02030f48cfa0.svg"
                        primaryAction={{
                            content: "Read More about theme app block",
                            url: "https://shopify.dev/apps/online-store/verify-support",
                        }}
                    ></CalloutCard>
                </Page>
                </Stack.Item>
                </Stack>
            </Card>
        </Layout.Section>
        <Layout.Section>
        </Layout.Section>
      </Layout>
    </Page>
  );
}
