<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMandatoryShopifyWebhooksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mandatory_shopify_webhooks', function (Blueprint $table) {
            $table->id();
            $table->string('shop_id')->nullable();
            $table->string('shop_domain')->nullable();
            $table->string('webhook_type')->nullable();
			$table->longText('response_data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mandatory_shopify_webhooks');
    }
}
